/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.impl;

import de.fhdw.gaming.core.domain.DefaultObserverFactoryProvider;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteGame;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteGameBuilder;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkantePlayerBuilder;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteStrategy;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.impl.KopfzahlkanteGameImpl;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.impl.KopfzahlkantePlayerBuilderImpl;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.impl.KopfzahlkanteStateImpl;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.moves.impl.AbstractKopfzahlkanteMove;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;

final class KopfzahlkanteGameBuilderImpl
implements KopfzahlkanteGameBuilder {
    private ObserverFactoryProvider observerFactoryProvider = new DefaultObserverFactoryProvider();
    private Optional<KopfzahlkantePlayerBuilder> firstPlayer = Optional.empty();
    private Optional<KopfzahlkanteStrategy> firstPlayerStrategy = Optional.empty();
    private Optional<KopfzahlkantePlayerBuilder> secondPlayer = Optional.empty();
    private Optional<KopfzahlkanteStrategy> secondPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    KopfzahlkanteGameBuilderImpl() {
    }

    @Override
    public KopfzahlkantePlayerBuilder createPlayerBuilder() {
        return new KopfzahlkantePlayerBuilderImpl();
    }

    @Override
    public KopfzahlkanteGameBuilder addPlayerBuilder(KopfzahlkantePlayerBuilder playerBuilder, KopfzahlkanteStrategy strategy) throws GameException {
        Objects.requireNonNull(playerBuilder);
        if (this.firstPlayer.isEmpty()) {
            this.firstPlayer = Optional.of(playerBuilder);
            this.firstPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "firstPlayerStrategy"));
        } else if (this.secondPlayer.isEmpty()) {
            this.secondPlayer = Optional.of(playerBuilder);
            this.secondPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "secondPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are now allowed.", new Object[0]));
        }
        return this;
    }

    public KopfzahlkanteGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public KopfzahlkanteGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.observerFactoryProvider = newObserverFactoryProvider;
        return this;
    }

    @Override
    public KopfzahlkanteGame build(int id) throws GameException, InterruptedException {
        if (!this.firstPlayer.isPresent() || !this.secondPlayer.isPresent()) {
            throw new GameException("A Kopfzahlkante game needs two players.");
        }
        KopfzahlkanteStateImpl initialState = new KopfzahlkanteStateImpl(this.firstPlayer.get(), this.secondPlayer.get());
        LinkedHashMap<String, KopfzahlkanteStrategy> strategies = new LinkedHashMap<String, KopfzahlkanteStrategy>();
        strategies.put(initialState.getFirstPlayer().getName(), this.firstPlayerStrategy.orElseThrow());
        strategies.put(initialState.getSecondPlayer().getName(), this.secondPlayerStrategy.orElseThrow());
        return new KopfzahlkanteGameImpl(id, initialState, strategies, this.maxComputationTimePerMove, AbstractKopfzahlkanteMove.class::isInstance, this.observerFactoryProvider);
    }
}

