package de.fhdw.gaming.ipspiel21.kopfzahlkante.strategy;

import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteStrategy;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.factory.KopfzahlkanteStrategyFactory;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.moves.factory.KopfzahlkanteMoveFactory;

/**
 * Implements {@link KopfzahlkanteStrategyFactory} by creating a
 * {@link KopfzahlkanteRandomMoveStrategy}.
 *
 */
public class KopfzahlkanteRandomMoveStrategyFactory implements KopfzahlkanteStrategyFactory {

    @Override
    public KopfzahlkanteStrategy create(final KopfzahlkanteMoveFactory moveFactory) {
        return new KopfzahlkanteRandomMoveStrategy(moveFactory);
    }

}
