/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-kopfzahlkante.
 *
 * Ipspiel21-kopfzahlkante is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-kopfzahlkante is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-kopfzahlkante. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.kopfzahlkante.strategy;

import java.util.Optional;

import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkantePlayer;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteState;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteStrategy;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.moves.KopfzahlkanteMove;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.moves.factory.KopfzahlkanteMoveFactory;

/**
 * Implements {@link KopfzahlkanteStrategy} by always saying "Kante".
 */
public final class KopfzahlkanteSayKanteStrategy implements KopfzahlkanteStrategy {

    /**
     * The factory for creating Kopfzahlkante moves.
     */
    private final KopfzahlkanteMoveFactory moveFactory;

    /**
     * Creates an {@link KopfzahlSayKanteStrategy}.
     *
     * @param moveFactory The factory for creating Kopfzahlkante moves.
     */
    KopfzahlkanteSayKanteStrategy(final KopfzahlkanteMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<KopfzahlkanteMove> computeNextMove(final int gameId, final KopfzahlkantePlayer player,
            final KopfzahlkanteState state) {
        return Optional.of(this.moveFactory.createKanteMove());
    }

    @Override
    public String toString() {
        return KopfzahlkanteSayKanteStrategy.class.getSimpleName();
    }
}
