/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.impl;

import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkantePlayer;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.KopfzahlkanteState;
import de.fhdw.gaming.ipspiel21.kopfzahlkante.domain.SaidMove;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class KopfzahlkantePlayerImpl
implements KopfzahlkantePlayer {
    private final KopfzahlkanteState gameState;
    private final String name;
    private final Map<SaidMove, Map<SaidMove, Double>> possibleOutcomes;

    KopfzahlkantePlayerImpl(KopfzahlkanteState gameState, String name, Map<SaidMove, Map<SaidMove, Double>> possibleOutcomes) {
        this.gameState = gameState;
        this.name = Objects.requireNonNull(name, "name");
        this.possibleOutcomes = Collections.unmodifiableMap(new LinkedHashMap<SaidMove, Map<SaidMove, Double>>(Objects.requireNonNull(possibleOutcomes, "possibleOutcomes")));
    }

    public String toString() {
        return String.format("KopfzahlkantePlayer[name=%s, state=%s, outcome=%s]", this.name, this.getState(), this.getOutcome());
    }

    public boolean equals(Object obj) {
        if (obj instanceof KopfzahlkantePlayerImpl) {
            KopfzahlkantePlayerImpl other = (KopfzahlkantePlayerImpl)obj;
            return this.name.equals(other.name) && this.getState().equals((Object)other.getState()) && this.getOutcome().equals(other.getOutcome());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Map<SaidMove, Map<SaidMove, Double>> getPossibleOutcomes() {
        return this.possibleOutcomes;
    }

    @Override
    public KopfzahlkantePlayer deepCopy(KopfzahlkanteState newGameState) {
        return new KopfzahlkantePlayerImpl(newGameState, this.name, this.possibleOutcomes);
    }

    public PlayerState getState() {
        return this.gameState.getPlayerState(this.name);
    }

    public Optional<Double> getOutcome() {
        return this.gameState.getPlayerOutcome(this.name);
    }
}

