/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-kopfzahlkante.
 *
 * Ipspiel21-kopfzahlkante is free software: you can redistribute it and/or modify it 
 * under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-kopfzahlkante is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-kopfzahlkante. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.kopfzahlkante.domain;

import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.ui.InputProvider;

/**
 * A Kopfzahlkante {@link GameBuilderFactory} which allows to create a
 * Kopfzahlkante game builder.
 */
public interface KopfzahlkanteGameBuilderFactory extends GameBuilderFactory {

    /**
     * Player's outcome on Kopf/Kopf.
     */
    String PARAM_PLAYER_OUTCOME_ON_KOPF_KOPF = "playerOutcomeOnKopfKopf";

    /**
     * Player's outcome on Kopf/Zahl.
     */
    String PARAM_PLAYER_OUTCOME_ON_KOPF_ZAHL = "playerOutcomeOnKopfZahl";

    /**
     * Player's outcome on Kopf/Kante.
     */
    String PARAM_PLAYER_OUTCOME_ON_KOPF_KANTE = "playerOutcomeOnKopfKante";

    /**
     * Player's outcome on Zahl/Kopf.
     */
    String PARAM_PLAYER_OUTCOME_ON_ZAHL_KOPF = "playerOutcomeOnZahlKopf";

    /**
     * Player's outcome on Zahl/Zahl.
     */
    String PARAM_PLAYER_OUTCOME_ON_ZAHL_ZAHL = "playerOutcomeOnZahlZahl";

    /**
     * Player's outcome on Kopf/Kante.
     */
    String PARAM_PLAYER_OUTCOME_ON_ZAHL_KANTE = "playerOutcomeOnZahlKante";

    /**
     * Player's outcome on Kante/Kopf.
     */
    String PARAM_PLAYER_OUTCOME_ON_KANTE_KOPF = "playerOutcomeOnKanteKopf";

    /**
     * Player's outcome on Kante/Zahl.
     */
    String PARAM_PLAYER_OUTCOME_ON_KANTE_ZAHL = "playerOutcomeOnKanteZahl";

    /**
     * Player's outcome on Kante/Kante.
     */
    String PARAM_PLAYER_OUTCOME_ON_KANTE_KANTE = "playerOutcomeOnKanteKante";

    @Override
    KopfzahlkanteGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException;
}
