package de.fhdw.gaming.ipspiel21.searchtrees.domain;

import java.util.Collection;

import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;

/**
 * Represent the next moves' generator.
 *
 * @param <P>
 * @param <S>
 * @param <M>
 *
 */
public interface NextMoveGenerator<P extends Player, S extends State<P, S>, M extends Move<P, S>> {

    /**
     * Get all next moves of current player and current game state.
     *
     * @param state  The state of the game.
     * @param player The current player.
     * @return possible next moves.
     */
    Collection<M> getAllNextMoves(S state, P player);

}