/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-tictactoe-gui.
 *
 * ipspiel21-tictactoe-gui is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * ipspiel21-tictactoe-gui is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * ipspiel21-tictactoe-gui. If not, see <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.tictactoe.gui;

import de.fhdw.gaming.ipspiel21.tictactoe.core.domain.TicTacToePlayer;
import de.fhdw.gaming.ipspiel21.tictactoe.core.domain.TicTacToeState;
import de.fhdw.gaming.ipspiel21.tictactoe.gui.event.TicTacToeBoardEvent;

/**
 * Provides input from the user interacting with a Tic Tac Toe board.
 */
public interface TicTacToeBoardEventProvider {

    /**
     * Waits for a user event and returns it.
     *
     * @param player It is this player's turn.
     * @param state  A copy of the game state.
     * @return The {@link TicTacToeBoardEvent} generated by the user.
     */
    TicTacToeBoardEvent waitForEvent(TicTacToePlayer player, TicTacToeState state);

    /**
     * If the provider is currently waiting for a user event, the wait operation will be cancelled.
     */
    void cancelWaiting();
}
