
package de.fhdw.gaming.ipspiel21.viergewinnt.gui;

import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntPlayer;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntState;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.event.VierGewinntBoardEvent;

/**
 * Provides input from the user interacting with a Vier Gewinnt  board.
 */
public interface VierGewinntBoardEventProvider {

    /**
     * Waits for a user event and returns it.
     *
     * @param player It is this player's turn.
     * @param state  A copy of the game state.
     * @return The {@link VierGewinntBoardEvent} generated by the user.
     */
    VierGewinntBoardEvent waitForEvent(VierGewinntPlayer player, VierGewinntState state);

    /**
     * If the provider is currently waiting for a user event, the wait operation will be cancelled.
     */
    void cancelWaiting();
}
