
package de.fhdw.gaming.ipspiel21.viergewinnt.gui.impl;

import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntFieldState;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.util.Duration;

/**
 * Displays a VierGewinnt field.
 */
final class VierGewinntFieldView extends Region {

    /**
     * The field state.
     */
    private VierGewinntFieldState fieldState;
    /**
     * The canvas.
     */
    private final Canvas canvas;
    /**
     * The duration of a move.
     */
    private final ObjectProperty<Duration> moveDuration;
    /**
     * Creates an {@link VierGewinntFieldView}.
     *
     * @param fieldState The field state.
     */
    VierGewinntFieldView(final VierGewinntFieldState fieldState) {
        this.fieldState = fieldState;
        this.moveDuration = new SimpleObjectProperty<>(Duration.millis(500.0));
        this.canvas = new Canvas() {

            @Override
            public boolean isResizable() {
                return true;
            }

            @Override
            public double prefWidth(final double height) {
                return 0.0;
            }

            @Override
            public double prefHeight(final double width) {
                return 0.0;
            }

            @Override
            public double maxWidth(final double height) {
                return Double.POSITIVE_INFINITY;
            }

            @Override
            public double maxHeight(final double width) {
                return Double.POSITIVE_INFINITY;
            }
        };

        this.canvas.widthProperty().bind(this.widthProperty());
        this.canvas.heightProperty().bind(this.heightProperty());
        this.getChildren().add(this.canvas);

        this.widthProperty().addListener(
                (final ObservableValue<? extends Number> observable, final Number oldValue, final Number newValue) -> {
                    this.draw();
                });
        this.heightProperty().addListener(
                (final ObservableValue<? extends Number> observable, final Number oldValue, final Number newValue) -> {
                    this.draw();
                });

        this.setMinSize(50.0, 50.0);
        this.setMaxSize(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    /**
     * Returns the move duration property.
     */
    ObjectProperty<Duration> moveDurationProperty() {
        return this.moveDuration;
    }

    /**
     * Updates the state of the field control.
     *
     * @param fieldState The field state.
     */
    void setFieldState(final VierGewinntFieldState fieldState) {
        this.fieldState = fieldState;
        this.draw();
    }

    /**
     * Draws the field.
     */
    private void draw() {
        final double sizeWidth = this.getWidth();
        final double sizeHeight = this.getHeight();

        final GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.setFill(Color.GREY);
        gc.fillRect(0.0, 0.0, sizeWidth, sizeHeight);
        
        gc.setFill(Color.WHITE);
        final double margin = sizeWidth * 0.1;
        gc.fillOval(margin, margin, sizeWidth - 2 * margin, sizeWidth - 2 * margin);


        switch (this.fieldState) {
        case EMPTY:
            // nothing to do
            break;
        case YELLOW:
            gc.setFill(Color.YELLOW);
            gc.fillOval(margin, margin, sizeWidth - 2 * margin, sizeWidth - 2 * margin);
            break;
        case RED:
            gc.setFill(Color.RED);
            gc.fillOval(margin, margin, sizeWidth - 2 * margin, sizeWidth - 2 * margin);
            break;
        default:
            throw new UnsupportedOperationException(
                    String.format("Unknown Vier gewinnt field state '%s'.", this.fieldState));
        }
    }
}
