
package de.fhdw.gaming.ipspiel21.viergewinnt.gui.event;

import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntPosition;

/**
 * Represents an {@link VierGewinntBoardEvent} where the user selected a field to make a move.
 */
public final class VierGewinntMakeMoveBoardEvent implements VierGewinntBoardEvent {

    /**
     * The position of the field selected.
     */
    private final VierGewinntPosition fieldPosition;

    /**
     * Constructor.
     *
     * @param fieldPosition The position of the field selected.
     */
    public VierGewinntMakeMoveBoardEvent(final VierGewinntPosition fieldPosition) {
        this.fieldPosition = fieldPosition;
    }

    /**
     * Returns the position of the field selected.
     */
    public VierGewinntPosition getFieldPosition() {
        return this.fieldPosition;
    }

    @Override
    public void accept(final VierGewinntBoardEventVisitor visitor) {
        visitor.handleMakeMove(this);
    }
}
