package de.fhdw.ipspiel21.viergewinnt.strategies.group1.strategy;

import java.util.Optional;
import java.util.Random;
import java.util.Set;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntField;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntPlayer;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntState;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntStrategy;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.moves.VierGewinntMove;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.moves.factory.VierGewinntMoveFactory;

/**
 * Random Strategy.
 */
public class VierGewinntRandomStrategy implements VierGewinntStrategy {

    /**
     * The MoveFactory.
     */
    private final VierGewinntMoveFactory moveFactory;

    /**
     * Constructor which using the given Move Factory.
     * 
     * @param moveFactory
     */
    VierGewinntRandomStrategy(final VierGewinntMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<VierGewinntMove> computeNextMove(final int gameId, final VierGewinntPlayer player,
            final VierGewinntState state) throws GameException, InterruptedException {
        final Set<VierGewinntField> fields = state.getBoard().getAllPlayableFields();
        final Optional<VierGewinntField> field =
                fields.stream().skip(new Random().nextInt(fields.size())).findFirst();
        if (field.isPresent()) {
            return Optional.of(this.moveFactory.createMove(field.get().getPosition()));
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return "VierGewinnt Group1 Random";
    }

}
