package de.fhdw.ipspiel21.viergewinnt.strategies.group1.strategy;

import java.util.Optional;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.searchtrees.domain.SearchTreeAlgorithms;
import de.fhdw.gaming.ipspiel21.searchtrees.domain.impl.AlphaBetaImpl;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntFieldState;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntPlayer;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntState;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntStrategy;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.moves.VierGewinntMove;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.moves.factory.VierGewinntMoveFactory;

/**
 * This Strategie finding the next move using the Alpha Beta Algorhitm.
 */
public class VierGewinntStrategyAlphaBeta implements VierGewinntStrategy {

    /**
     * The Move Factory.
     */
    private final VierGewinntMoveFactory moveFactory;

    /**
     * Constructor for this class. Using the given MoveFactory.
     *
     * @param moveFactory
     */
    VierGewinntStrategyAlphaBeta(final VierGewinntMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<VierGewinntMove> computeNextMove(final int gameId, final VierGewinntPlayer player,
            final VierGewinntState state) throws GameException, InterruptedException {
        if (!state.getBoard().getFieldsBeing(VierGewinntFieldState.EMPTY).isEmpty()) {
            final SearchTreeAlgorithms<VierGewinntPlayer, VierGewinntState, VierGewinntMove> algorithm =
                    new AlphaBetaImpl<>();
            return algorithm.getBestMove(4, player, new VierGewinntNextMoveGenerator(this.moveFactory), state,
                    new VierGewinntEvaluation());
        } else {
            return Optional.empty();
        }
    }

    @Override
    public String toString() {
        return "VierGewinnt Group1 AlphaBeta";
    }

}
