/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayer;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaStrategy;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.DilemmaMove;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.factory.DilemmaMoveFactory;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.strategy.DilemmaTitForTatStrategy;
import de.fhdw.gaming.ipspiel21.evolution.GameHistoryCollection;
import java.util.Optional;

public final class DilemmaProberStrategy
implements DilemmaStrategy {
    private final DilemmaMoveFactory moveFactory;
    private final DilemmaTitForTatStrategy dilemmaTitForTatStrategy;

    public DilemmaProberStrategy(DilemmaMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
        this.dilemmaTitForTatStrategy = new DilemmaTitForTatStrategy(this.moveFactory);
    }

    public Optional<DilemmaMove> computeNextMove(int gameId, DilemmaPlayer player, DilemmaState state) throws GameException, InterruptedException {
        Integer games = player.getGameHistoryCollection().numberOfPlayedGames();
        switch (games) {
            case 0: {
                return Optional.of(this.moveFactory.createYesMove());
            }
            case 1: 
            case 2: {
                return Optional.of(this.moveFactory.createNoMove());
            }
        }
        return this.confess(state.getOtherPlayer(player).getGameHistoryCollection()) ? Optional.of(this.moveFactory.createNoMove()) : this.dilemmaTitForTatStrategy.computeNextMove(gameId, player, state);
    }

    private boolean confess(GameHistoryCollection historyCollection) {
        return historyCollection.getSpecificGameHistory(Integer.valueOf(historyCollection.numberOfPlayedGames() - 2)).getMove(Integer.valueOf(0)).equals(this.moveFactory.createYesMove()) && historyCollection.getSpecificGameHistory(Integer.valueOf(historyCollection.numberOfPlayedGames() - 3)).getMove(Integer.valueOf(0)).equals(this.moveFactory.createYesMove());
    }

    public String toString() {
        return DilemmaProberStrategy.class.getSimpleName();
    }
}

