/*
 * Copyright © 2021 Fachhochschule für die Wirtschaft (FHDW) Hannover
 *
 * This file is part of ipspiel21-freizeit.
 *
 * Ipspiel21-freizeit is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Ipspiel21-freizeit is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied  * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with ipspiel21-freizeit. If not, see
 * <http://www.gnu.org/licenses/>.
 */
package de.fhdw.gaming.ipspiel21.freizeit.domain;

import java.util.Map;

import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.ipspiel21.freizeit.moves.impl.AbstractFreizeitMove;

/**
 * Represents a Freizeit player.
 */
public interface FreizeitPlayer extends Player {

    /**
     * Returns the possible outcomes of this player. The key for the first-level map is the answer of the first player,
     * the key for the second-level map is the answer of the second player.
     */
    Map<AbstractFreizeitMove, Map<AbstractFreizeitMove, Double>> getPossibleOutcomes();

    /**
     * Performs a deep copy of this player and associates it with a new game state.
     *
     * @param newGameState The associated game state.
     */
    FreizeitPlayer deepCopy(FreizeitState newGameState);

}
