/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.viergewinnt.gui.impl;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.gui.GuiObserver;
import de.fhdw.gaming.ipspiel21.viergewinnt.core.domain.VierGewinntGame;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.VierGewinntBoardEventProvider;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.impl.VierGewinntBoardEventProviderImpl;
import de.fhdw.gaming.ipspiel21.viergewinnt.gui.impl.VierGewinntBoardView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.Node;

final class VierGewinntGuiObserverImpl
implements GuiObserver {
    private static final AtomicReference<WeakReference<VierGewinntGuiObserverImpl>> INSTANCE = new AtomicReference();
    private final Map<Integer, VierGewinntBoardView> boardViews;

    VierGewinntGuiObserverImpl() {
        INSTANCE.compareAndSet(null, new WeakReference<VierGewinntGuiObserverImpl>(this));
        this.boardViews = new LinkedHashMap<Integer, VierGewinntBoardView>();
    }

    static Optional<VierGewinntBoardEventProvider> getEventProvider(int gameId) {
        VierGewinntGuiObserverImpl instance = Optional.ofNullable(INSTANCE.get()).map(Reference::get).orElse(null);
        if (instance == null) {
            return Optional.empty();
        }
        VierGewinntBoardView boardView = instance.boardViews.get(gameId);
        return boardView == null ? Optional.empty() : Optional.of(new VierGewinntBoardEventProviderImpl(boardView));
    }

    public Optional<Node> gameCreated(Game<?, ?, ?, ?> game) {
        if (game instanceof VierGewinntGame) {
            VierGewinntBoardView boardView = new VierGewinntBoardView((VierGewinntGame)game);
            this.boardViews.put(game.getId(), boardView);
            return Optional.of(boardView.getNode());
        }
        return Optional.empty();
    }

    public void gamePaused(Game<?, ?, ?, ?> game) {
        VierGewinntBoardView boardView;
        if (game instanceof VierGewinntGame && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gamePaused((VierGewinntGame)game);
        }
    }

    public void gameResumed(Game<?, ?, ?, ?> game) {
        VierGewinntBoardView boardView;
        if (game instanceof VierGewinntGame && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gameResumed((VierGewinntGame)game);
        }
    }

    public void gameDestroyed(Game<?, ?, ?, ?> game) {
        VierGewinntBoardView boardView;
        if (game instanceof VierGewinntGame && (boardView = this.boardViews.remove(game.getId())) != null) {
            boardView.destroy((VierGewinntGame)game);
        }
    }
}

