/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayer;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaPlayerBuilder;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.domain.DilemmaState;
import de.fhdw.gaming.ipspiel21.dilemmaOriginal.moves.impl.AbstractDilemmaMove;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class DilemmaStateImpl
implements DilemmaState {
    private final DilemmaPlayer firstPlayer;
    private final DilemmaPlayer secondPlayer;
    private final Map<String, PlayerState> playerStates;
    private final Map<String, Double> playerOutcomes;
    private final Map<Double, PlayerState> matchPlayerstate;

    DilemmaStateImpl(DilemmaPlayerBuilder firstPlayerBuilder, DilemmaPlayerBuilder secondPlayerBuilder) throws GameException {
        this.firstPlayer = Objects.requireNonNull(firstPlayerBuilder, "firstPlayerBuilder").build(this);
        this.secondPlayer = Objects.requireNonNull(secondPlayerBuilder, "secondPlayerBuilder").build(this);
        this.playerOutcomes = new LinkedHashMap<String, Double>();
        this.playerStates = new LinkedHashMap<String, PlayerState>();
        this.playerStates.put(this.firstPlayer.getName(), PlayerState.PLAYING);
        this.playerStates.put(this.secondPlayer.getName(), PlayerState.PLAYING);
        this.matchPlayerstate = new LinkedHashMap<Double, PlayerState>();
        this.matchPlayerstate.put(0.0, PlayerState.WON);
        this.matchPlayerstate.put(-1.0, PlayerState.DRAW);
        this.matchPlayerstate.put(-10.0, PlayerState.LOST);
        this.matchPlayerstate.put(-8.0, PlayerState.DRAW);
        if (this.firstPlayer.getName().equals(this.secondPlayer.getName())) {
            throw new IllegalArgumentException(String.format("Both players have the same name '%s'.", this.firstPlayer.getName()));
        }
    }

    DilemmaStateImpl(DilemmaStateImpl source) {
        this.firstPlayer = source.firstPlayer.deepCopy(this);
        this.secondPlayer = source.secondPlayer.deepCopy(this);
        this.playerOutcomes = new LinkedHashMap<String, Double>(source.playerOutcomes);
        this.playerStates = new LinkedHashMap<String, PlayerState>();
        this.playerStates.put(this.firstPlayer.getName(), source.playerStates.get(this.firstPlayer.getName()));
        this.playerStates.put(this.secondPlayer.getName(), source.playerStates.get(this.secondPlayer.getName()));
        this.matchPlayerstate = source.matchPlayerstate;
    }

    @Override
    public DilemmaPlayer getFirstPlayer() {
        return this.firstPlayer;
    }

    @Override
    public DilemmaPlayer getSecondPlayer() {
        return this.secondPlayer;
    }

    public String toString() {
        return String.format("DilemmaState[firstPlayer=%s, secondPlayer=%s, playerOutcomes=%s, playerStates=%s]", this.firstPlayer, this.secondPlayer, this.playerOutcomes, this.playerStates);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DilemmaStateImpl) {
            DilemmaStateImpl other = (DilemmaStateImpl)obj;
            return this.firstPlayer.equals(other.firstPlayer) && this.secondPlayer.equals(other.secondPlayer);
        }
        return false;
    }

    public DilemmaState deepCopy() {
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.firstPlayer, this.secondPlayer);
    }

    public Map<String, DilemmaPlayer> getPlayers() {
        LinkedHashMap<String, DilemmaPlayer> result = new LinkedHashMap<String, DilemmaPlayer>();
        result.put(this.firstPlayer.getName(), this.firstPlayer);
        result.put(this.secondPlayer.getName(), this.secondPlayer);
        return result;
    }

    public PlayerState getPlayerState(String playerName) throws IllegalArgumentException {
        PlayerState playerState = this.playerStates.get(playerName);
        if (playerState != null) {
            return playerState;
        }
        throw new IllegalArgumentException(String.format("Unknown player %s.", playerName));
    }

    public void setPlayerState(String playerName, PlayerState newState) throws IllegalArgumentException {
        if (this.playerStates.containsKey(playerName)) {
            this.playerStates.put(playerName, newState);
            if (newState.equals((Object)PlayerState.PLAYING)) {
                this.playerOutcomes.remove(playerName);
            }
        } else {
            throw new IllegalArgumentException(String.format("Unknown player %s.", playerName));
        }
    }

    public Optional<Double> getPlayerOutcome(String playerName) throws IllegalArgumentException {
        if (this.playerStates.containsKey(playerName)) {
            Double outcome = this.playerOutcomes.get(playerName);
            return outcome != null ? Optional.of(outcome) : DilemmaState.super.getPlayerOutcome(playerName);
        }
        throw new IllegalArgumentException(String.format("Unknown player %s.", playerName));
    }

    public void setPlayerOutcome(String playerName, double newOutcome) throws IllegalArgumentException {
        if (this.getPlayerState(playerName).equals((Object)PlayerState.PLAYING)) {
            throw new IllegalArgumentException(String.format("Cannot set outcome for player %s.", playerName));
        }
        this.playerOutcomes.put(playerName, newOutcome);
    }

    public Set<DilemmaPlayer> computeNextPlayers() {
        LinkedHashSet<DilemmaPlayer> playersWithoutAnswer = new LinkedHashSet<DilemmaPlayer>();
        if (this.getFirstPlayer().getMove() == null) {
            playersWithoutAnswer.add(this.firstPlayer);
        }
        if (this.getSecondPlayer().getMove() == null) {
            playersWithoutAnswer.add(this.secondPlayer);
        }
        return playersWithoutAnswer;
    }

    public void nextTurn() {
        this.calculateOutcome();
    }

    private void calculateOutcome() {
        if (this.computeNextPlayers().isEmpty()) {
            this.generateOutcomes(this.firstPlayer, this.secondPlayer);
            this.generateOutcomes(this.secondPlayer, this.firstPlayer);
        }
    }

    private void generateOutcomes(DilemmaPlayer fromP1, DilemmaPlayer p2) {
        Map<AbstractDilemmaMove, Map<AbstractDilemmaMove, Double>> matches = this.firstPlayer.getPossibleOutcomes();
        Map<AbstractDilemmaMove, Double> forplayer1 = matches.get(fromP1.getMove());
        Double forPlayer2 = forplayer1.get(p2.getMove());
        this.setPlayerState(fromP1.getName(), this.matchPlayerstate.get(forPlayer2));
        this.setPlayerOutcome(fromP1.getName(), forPlayer2);
    }

    @Override
    public void setAnswer(DilemmaPlayer player, AbstractDilemmaMove move) {
        this.getPlayers().get(player.getName()).setMove(move);
    }

    @Override
    public DilemmaPlayer getOtherPlayer(DilemmaPlayer player) {
        return this.firstPlayer.equals(player) ? this.secondPlayer : this.firstPlayer;
    }
}

