/*
* Copyright © 2021-2022 Fachhochschule für die Wirtschaft (FHDW) Hannover
*
* This file is part of ipspiel22-demo.
*
* Ipspiel22-demo is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
* version.
*
* Ipspiel22-demo is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
* warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along with ipspiel22-demo. If not, see
* <http://www.gnu.org/licenses/>.
*/
package de.fhdw.gaming.ipspiel22.demo.domain.impl;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel22.demo.domain.DemoGame;
import de.fhdw.gaming.ipspiel22.demo.domain.DemoMoveChecker;
import de.fhdw.gaming.ipspiel22.demo.domain.DemoPlayer;
import de.fhdw.gaming.ipspiel22.demo.domain.DemoState;
import de.fhdw.gaming.ipspiel22.demo.domain.DemoStrategy;
import de.fhdw.gaming.ipspiel22.demo.moves.DemoMove;
import de.fhdw.gaming.ipspiel22.demo.moves.factory.DemoMoveFactory;
import de.fhdw.gaming.ipspiel22.demo.moves.impl.DemoDefaultMoveFactory;

/**
 * Implements the Demo game.
 */
final class DemoGameImpl extends DefaultGame<DemoPlayer, DemoState, DemoMove, DemoStrategy> implements DemoGame {

    /**
     * The move factory.
     */
    private final DemoMoveFactory moveFactory;

    /**
     * Creates a Demo game.
     *
     * @param id                        The ID of this game.
     * @param initialState              The initial state of the game.
     * @param strategies                The players' strategies.
     * @param maxComputationTimePerMove The maximum computation time per move in seconds.
     * @param moveChecker               The move checker.
     * @param observerFactoryProvider   The {@link ObserverFactoryProvider}.
     * @throws IllegalArgumentException if the player sets do not match.
     * @throws InterruptedException     if creating the game has been interrupted.
     */
    DemoGameImpl(final int id, final DemoState initialState, final Map<String, DemoStrategy> strategies,
            final long maxComputationTimePerMove, final DemoMoveChecker moveChecker,
            final ObserverFactoryProvider observerFactoryProvider)
            throws IllegalArgumentException, InterruptedException {

        super(id, initialState, strategies, maxComputationTimePerMove, moveChecker, observerFactoryProvider);
        this.moveFactory = new DemoDefaultMoveFactory();
    }

    @Override
    public Optional<DemoMove> chooseRandomMove(final DemoPlayer player, final DemoState state) {
        // choose "no" to punish lame strategies
        return Optional.of(this.moveFactory.createNoMove());
    }

    @Override
    public String toString() {
        return String.format("DemoGame[id=%d, %s]", this.getId(), this.gameToString());
    }
}