package de.fhdw.gaming.ipspiel22.vierGewinnt.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;

import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGAnswerEnum;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGField;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGStrategy;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.VGMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.factory.VGMoveFactory;

/**
 * Implements {@link VGStrategy} by choosing a random move.
 */
public class VGRandomMoveStrategy implements VGStrategy {
    /**
     * For choosing a random column.
     */
    private static final Random RANDOM = new Random();

    /**
     * Contains all possible moves.
     */
    private final List<VGMove> movesList;

    /**
     * First column move.
     */
    private final VGMove firstColumn;

    /**
     * Second column move.
     */
    private final VGMove secondColumn;

    /**
     * Third column move.
     */
    private final VGMove thirdColumn;

    /**
     * Fourth column move.
     */
    private final VGMove fourthColumn;

    /**
     * Fifth column move.
     */
    private final VGMove fifthColumn;

    /**
     * Sixth column move.
     */
    private final VGMove sixthColumn;

    /**
     * Seventh column move.
     */
    private final VGMove seventhColumn;
  
    /**
     * Creates an {@link VGRandomMoveStrategy}.
     *
     * @param moveFactory The factory for creating Vier gewinnt moves.
     */
    public VGRandomMoveStrategy(final VGMoveFactory moveFactory) {
        this.firstColumn = moveFactory.createFirstColumnMove();
        this.secondColumn = moveFactory.createSecondColumnMove();
        this.thirdColumn = moveFactory.createThirdColumnMove();
        this.fourthColumn = moveFactory.createFourthColumnMove();
        this.fifthColumn = moveFactory.createFifthColumnMove();
        this.sixthColumn = moveFactory.createSixthColumnMove();
        this.seventhColumn = moveFactory.createSeventhColumnMove();
        this.movesList = new ArrayList<>(Arrays.asList(this.firstColumn,
                this.secondColumn,
                this.thirdColumn,
                this.fourthColumn,
                this.fifthColumn,
                this.sixthColumn,
                this.seventhColumn));
    }

    @Override
    public Optional<VGMove> computeNextMove(final int gameId, final VGPlayer player, final VGState state) {
        checkFirstColumn(state.getBoard().getNextFieldInColumn(VGAnswerEnum.FIRSTCOLUMN));
        checkSecondColumn(state.getBoard().getNextFieldInColumn(VGAnswerEnum.SECONDCOLUMN));
        checkThirdColumn(state.getBoard().getNextFieldInColumn(VGAnswerEnum.THIRDCOLUMN));
        checkFourthColumn(state.getBoard().getNextFieldInColumn(VGAnswerEnum.FOURTHCOLUMN));
        checkFifthColumn(state.getBoard().getNextFieldInColumn(VGAnswerEnum.FITFHCOLUMN));
        checkSixthColumn(state.getBoard().getNextFieldInColumn(VGAnswerEnum.SIXTHCOLUMN));
        checkSeventhColumn(state.getBoard().getNextFieldInColumn(VGAnswerEnum.SEVENTHCOLUMN));
        final int index = RANDOM.nextInt(movesList.size());
        return Optional.of(movesList.get(index));
    }

    /**
     * Checks if first Column is full.
     * 
     * @param vgField if its null, the first column will be removed out of the possible column-list.
     */
    private void checkFirstColumn(final VGField vgField) {
        if (movesList.contains(this.firstColumn) && Objects.isNull(vgField)) {
            movesList.remove(this.firstColumn);
        }
    }

    /**
     * Checks if second Column is full.
     * 
     * @param vgField if its null, the second column will be removed out of the possible column-list.
     */
    private void checkSecondColumn(final VGField vgField) {
        if (movesList.contains(this.secondColumn) && Objects.isNull(vgField)) {
            movesList.remove(this.secondColumn);
        }
    }

    /**
     * Checks if third Column is full.
     * 
     * @param vgField if its null, the third column will be removed out of the possible column-list.
     */
    private void checkThirdColumn(final VGField vgField) {
        if (movesList.contains(this.thirdColumn) && Objects.isNull(vgField)) {
            movesList.remove(this.thirdColumn);
        }
    }

    /**
     * Checks if fourth Column is full.
     * 
     * @param vgField if its null, the fourth column will be removed out of the possible column-list.
     */
    private void checkFourthColumn(final VGField vgField) {
        if (movesList.contains(this.fourthColumn) && Objects.isNull(vgField)) {
            movesList.remove(this.fourthColumn);
        }
    }

    /**
     * Checks if fifth Column is full.
     * 
     * @param vgField if its null, the fifth column will be removed out of the possible column-list.
     */
    private void checkFifthColumn(final VGField vgField) {
        if (movesList.contains(this.fifthColumn) && Objects.isNull(vgField)) {
            movesList.remove(this.fifthColumn);
        }
    }

    /**
     * Checks if sixth Column is full.
     * 
     * @param vgField if its null, the sixth column will be removed out of the possible column-list.
     */
    private void checkSixthColumn(final VGField vgField) {
        if (movesList.contains(this.sixthColumn) && Objects.isNull(vgField)) {
            movesList.remove(this.sixthColumn);
        }
    }

    /**
     * Checks if seventh Column is full.
     * 
     * @param vgField if its null, the seventh column will be removed out of the possible column-list.
     */
    private void checkSeventhColumn(final VGField vgField) {
        if (movesList.contains(this.seventhColumn) && Objects.isNull(vgField)) {
            movesList.remove(this.seventhColumn);
        }
    }

    @Override
    public String toString() {
        return VGRandomMoveStrategy.class.getSimpleName();
    }
}
