package de.schereSteinPapier.strategy;

import java.util.Optional;

import de.schereSteinPapier.domain.SSPPlayer;
import de.schereSteinPapier.domain.SSPState;
import de.schereSteinPapier.domain.SSPStrategy;
import de.schereSteinPapier.moves.SSPMove;
import de.schereSteinPapier.moves.factory.SSPMoveFactory;

/**
 * Implements {@link SSPStrategy} by always saying "Schere".
 */
public class SSPSaySchereStrategy implements SSPStrategy {

    /**
     * The factory for creating SSP moves.
     */
    private final SSPMoveFactory moveFactory;

    /**
     * Creates an {@link SSPSaySchereStrategy}.
     *
     * @param moveFactory The factory for creating Demo moves.
     */
    public SSPSaySchereStrategy(final SSPMoveFactory moveFactory) {
        this.moveFactory = moveFactory;
    }

    @Override
    public Optional<SSPMove> computeNextMove(final int gameId, final SSPPlayer player, final SSPState state) {
        return Optional.of(this.moveFactory.createSchereMove());
    }

    @Override
    public String toString() {
        return SSPSaySchereStrategy.class.getSimpleName();
    }
}
