/*
 * Decompiled with CFR 0.152.
 */
package de.schereSteinPapier.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.schereSteinPapier.domain.SSPPlayer;
import de.schereSteinPapier.domain.SSPPlayerBuilder;
import de.schereSteinPapier.domain.impl.SSPPlayerImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public final class SSPPlayerBuilderImpl
implements SSPPlayerBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<Map<String, Map<String, Double>>> possibleOutcomes = Optional.empty();

    SSPPlayerBuilderImpl() {
    }

    @Override
    public SSPPlayerBuilderImpl changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public SSPPlayerBuilder changePossibleOutcomes(Map<String, Map<String, Double>> newPossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newPossibleOutcomes);
        return this;
    }

    @Override
    public SSPPlayer build() throws GameException {
        return new SSPPlayerImpl(this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<String, Map<String, Double>> checkPossibleOutcomes(Map<String, Map<String, Double>> outcomes) {
        this.checkPossibleOutcome(outcomes, "Schere", "Schere");
        this.checkPossibleOutcome(outcomes, "Schere", "Stein");
        this.checkPossibleOutcome(outcomes, "Schere", "Papier");
        this.checkPossibleOutcome(outcomes, "Stein", "Stein");
        this.checkPossibleOutcome(outcomes, "Stein", "Schere");
        this.checkPossibleOutcome(outcomes, "Stein", "Papier");
        this.checkPossibleOutcome(outcomes, "Papier", "Papier");
        this.checkPossibleOutcome(outcomes, "Papier", "Stein");
        this.checkPossibleOutcome(outcomes, "Papier", "Schere");
        return outcomes;
    }

    private void checkPossibleOutcome(Map<String, Map<String, Double>> outcomes, String firstChoice, String secondChoice) {
        if (outcomes.getOrDefault(firstChoice, Collections.emptyMap()).get(secondChoice) == null) {
            throw new IllegalArgumentException(String.format("No outcome defined for player '%s' and combination %s/%s.", this.name, firstChoice, secondChoice));
        }
    }
}

