package de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

/**
 * Implements {@link KopfundZahlStrategyFactoryProvider} by using the {@link ServiceLoader}.
 */
public final class KopfundZahlDefaultStrategyFactoryProvider implements KopfundZahlStrategyFactoryProvider {

    @Override
    public List<KopfundZahlStrategyFactory> getStrategyFactories() {
        final ServiceLoader<KopfundZahlStrategyFactory> services = ServiceLoader.load(KopfundZahlStrategyFactory.class);
        final List<KopfundZahlStrategyFactory> list = new ArrayList<>();
        services.iterator().forEachRemaining(list::add);
        return list;
    }

}
