package de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.Player;

/**
 * Represents a Gefangenen Dilemma player.
 */
public interface GDPlayer extends Player<GDPlayer> {
    /**
     * Returns the possible outcomes of this player. The key for the first-level map is the answer of the first player,
     * the key for the second-level map is the answer of the second player.
     */
    Map<Boolean, Map<Boolean, Double>> getPossibleOutcomes();

    /**
     * Returns the answer of this player. {@code true} means "staying quiet", {@code false} means "making a statement".
     */
    Optional<Boolean> getAnswer();

    /**
     * Sets the answer of this player.
     *
     * @param newAnswer The answer to set. {@code true} means "staying quiet", {@code false} means "making a statement".
     * @throws IllegalStateException if an answer has already been set.
     */
    void setAnswer(boolean newAnswer);
}
