/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.kopfundzahl.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlPlayer;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlPlayerBuilder;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.impl.KopfundZahlPlayerImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public final class KopfundZahlPlayerBuilderImpl
implements KopfundZahlPlayerBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<Map<Boolean, Map<Boolean, Double>>> possibleOutcomes = Optional.empty();

    @Override
    public KopfundZahlPlayerBuilderImpl changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public KopfundZahlPlayerBuilder changePossibleOutcomes(Map<Boolean, Map<Boolean, Double>> newpossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newpossibleOutcomes);
        return this;
    }

    @Override
    public KopfundZahlPlayer build() throws GameException {
        return new KopfundZahlPlayerImpl(this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<Boolean, Map<Boolean, Double>> checkPossibleOutcomes(Map<Boolean, Map<Boolean, Double>> outcomes) {
        this.checkPossibleOutcome(outcomes, false, false);
        this.checkPossibleOutcome(outcomes, false, true);
        this.checkPossibleOutcome(outcomes, true, false);
        this.checkPossibleOutcome(outcomes, true, true);
        return outcomes;
    }

    private void checkPossibleOutcome(Map<Boolean, Map<Boolean, Double>> outcomes, boolean firstChoice, boolean secondChoice) {
        if (outcomes.getOrDefault(firstChoice, Collections.emptyMap()).get(secondChoice) == null) {
            throw new IllegalArgumentException(String.format("No outcome defined for player '%s' and combination %s/%s.", this.name, KopfundZahlPlayerBuilderImpl.toAnswer(firstChoice), KopfundZahlPlayerBuilderImpl.toAnswer(secondChoice)));
        }
    }

    private static String toAnswer(boolean value) {
        return value ? "head" : "tail";
    }
}

