/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.kopfundzahl.domain.impl;

import de.fhdw.gaming.core.domain.DefaultObserverFactoryProvider;
import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlGame;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlGameBuilder;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlPlayer;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlPlayerBuilder;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.KopfundZahlStrategy;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.impl.KopfundZahlGameImpl;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.impl.KopfundZahlPlayerBuilderImpl;
import de.fhdw.gaming.ipspiel22.kopfundzahl.domain.impl.KopfundZahlStateImpl;
import de.fhdw.gaming.ipspiel22.kopfundzahl.moves.impl.AbstractKopfundZahlMove;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;

public final class KopfundZahlGameBuilderImpl
implements KopfundZahlGameBuilder {
    private ObserverFactoryProvider observerFactoryProvider = new DefaultObserverFactoryProvider();
    private Optional<KopfundZahlPlayer> firstPlayer = Optional.empty();
    private Optional<KopfundZahlStrategy> firstPlayerStrategy = Optional.empty();
    private Optional<KopfundZahlPlayer> secondPlayer = Optional.empty();
    private Optional<KopfundZahlStrategy> secondPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    @Override
    public KopfundZahlPlayerBuilder createPlayerBuilder() {
        return new KopfundZahlPlayerBuilderImpl();
    }

    @Override
    public KopfundZahlGameBuilder addPlayer(KopfundZahlPlayer player, KopfundZahlStrategy strategy) throws GameException {
        if (this.firstPlayer.isEmpty()) {
            this.firstPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.firstPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "firstPlayerStrategy"));
        } else if (this.secondPlayer.isEmpty()) {
            this.secondPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.secondPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "secondPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are now allowed.", new Object[0]));
        }
        return this;
    }

    public GameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public KopfundZahlGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.observerFactoryProvider = newObserverFactoryProvider;
        return this;
    }

    @Override
    public KopfundZahlGame build(int id) throws GameException, InterruptedException {
        if (!this.firstPlayer.isPresent() || !this.secondPlayer.isPresent()) {
            throw new GameException("A Head and Tail game needs two players.");
        }
        KopfundZahlStateImpl initialState = new KopfundZahlStateImpl(this.firstPlayer.get(), this.secondPlayer.get());
        LinkedHashMap<String, KopfundZahlStrategy> strategies = new LinkedHashMap<String, KopfundZahlStrategy>();
        strategies.put(initialState.getFirstPlayer().getName(), this.firstPlayerStrategy.orElseThrow());
        strategies.put(initialState.getSecondPlayer().getName(), this.secondPlayerStrategy.orElseThrow());
        return new KopfundZahlGameImpl(id, initialState, strategies, this.maxComputationTimePerMove, AbstractKopfundZahlMove.class::isInstance, this.observerFactoryProvider);
    }
}

