/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.PlayerState;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteAnswerEnum;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKantePlayer;
import de.fhdw.gaming.ipspiel22.kopfundzahlundkante.domain.KopfundZahlundKanteState;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class KopfundZahlundKanteStateImpl
implements KopfundZahlundKanteState {
    private final KopfundZahlundKantePlayer firstPlayer;
    private final KopfundZahlundKantePlayer secondPlayer;

    public KopfundZahlundKanteStateImpl(KopfundZahlundKantePlayer firstPlayer, KopfundZahlundKantePlayer secondPlayer) throws GameException {
        this.firstPlayer = Objects.requireNonNull(firstPlayer, "firstPlayer");
        this.secondPlayer = Objects.requireNonNull(secondPlayer, "secondPlayer");
        if (this.firstPlayer.getName().equals(this.secondPlayer.getName())) {
            throw new IllegalArgumentException(String.format("Both players have the same name '%s'.", this.firstPlayer.getName()));
        }
    }

    KopfundZahlundKanteStateImpl(KopfundZahlundKanteStateImpl source) {
        this.firstPlayer = (KopfundZahlundKantePlayer)source.firstPlayer.deepCopy();
        this.secondPlayer = (KopfundZahlundKantePlayer)source.secondPlayer.deepCopy();
    }

    @Override
    public KopfundZahlundKantePlayer getFirstPlayer() {
        return this.firstPlayer;
    }

    @Override
    public KopfundZahlundKantePlayer getSecondPlayer() {
        return this.secondPlayer;
    }

    public String toString() {
        return String.format("KopfundZahlundKanteState[firstPlayer=%s, secondPlayer=%s]", this.firstPlayer, this.secondPlayer);
    }

    public boolean equals(Object obj) {
        if (obj instanceof KopfundZahlundKanteStateImpl) {
            KopfundZahlundKanteStateImpl other = (KopfundZahlundKanteStateImpl)obj;
            return this.firstPlayer.equals(other.firstPlayer) && this.secondPlayer.equals(other.secondPlayer);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.firstPlayer, this.secondPlayer);
    }

    public KopfundZahlundKanteState deepCopy() {
        return new KopfundZahlundKanteStateImpl(this);
    }

    public Map<String, KopfundZahlundKantePlayer> getPlayers() {
        LinkedHashMap<String, KopfundZahlundKantePlayer> result = new LinkedHashMap<String, KopfundZahlundKantePlayer>();
        result.put(this.firstPlayer.getName(), this.firstPlayer);
        result.put(this.secondPlayer.getName(), this.secondPlayer);
        return result;
    }

    public Set<KopfundZahlundKantePlayer> computeNextPlayers() {
        LinkedHashSet<KopfundZahlundKantePlayer> playersWithoutMove = new LinkedHashSet<KopfundZahlundKantePlayer>();
        if (this.firstPlayer.getAnswer().isEmpty()) {
            playersWithoutMove.add(this.firstPlayer);
        }
        if (this.secondPlayer.getAnswer().isEmpty()) {
            playersWithoutMove.add(this.secondPlayer);
        }
        return playersWithoutMove;
    }

    public void nextTurn() {
        Set<KopfundZahlundKantePlayer> playersWithoutMove = this.computeNextPlayers();
        if (playersWithoutMove.isEmpty()) {
            KopfundZahlundKanteAnswerEnum answerOfFirstPlayer = this.firstPlayer.getAnswer().orElseThrow();
            KopfundZahlundKanteAnswerEnum answerOfSecondPlayer = this.secondPlayer.getAnswer().orElseThrow();
            Double outcomeOfFirstPlayer = this.firstPlayer.getPossibleOutcomes().get((Object)answerOfFirstPlayer).get((Object)answerOfSecondPlayer);
            this.firstPlayer.setState(KopfundZahlundKanteStateImpl.outcomeToState(outcomeOfFirstPlayer));
            this.firstPlayer.setOutcome(outcomeOfFirstPlayer);
            Double outcomeOfSecondPlayer = this.secondPlayer.getPossibleOutcomes().get((Object)answerOfFirstPlayer).get((Object)answerOfSecondPlayer);
            this.secondPlayer.setState(KopfundZahlundKanteStateImpl.outcomeToState(outcomeOfSecondPlayer));
            this.secondPlayer.setOutcome(outcomeOfSecondPlayer);
        }
    }

    private static PlayerState outcomeToState(Double outcome) {
        return outcome > 0.0 ? PlayerState.WON : PlayerState.LOST;
    }
}

