package de.schereSteinPapier.domain.impl;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.schereSteinPapier.domain.SSPGame;
import de.schereSteinPapier.domain.SSPMoveChecker;
import de.schereSteinPapier.domain.SSPPlayer;
import de.schereSteinPapier.domain.SSPState;
import de.schereSteinPapier.domain.SSPStrategy;
import de.schereSteinPapier.moves.SSPMove;
import de.schereSteinPapier.moves.factory.SSPMoveFactory;
import de.schereSteinPapier.moves.impl.SSPDefaultMoveFactory;

/**
 * Implements the SSP game.
 */
final class SSPGameImpl extends DefaultGame<SSPPlayer, SSPState, SSPMove, SSPStrategy> implements SSPGame {

    /**
     * The move factory.
     */
    private final SSPMoveFactory moveFactory;

    /**
     * Creates a SSP game.
     *
     * @param id                        The ID of this game.
     * @param initialState              The initial state of the game.
     * @param strategies                The players' strategies.
     * @param maxComputationTimePerMove The maximum computation time per move in seconds.
     * @param moveChecker               The move checker.
     * @param observerFactoryProvider   The {@link ObserverFactoryProvider}.
     * @throws IllegalArgumentException if the player sets do not match.
     * @throws InterruptedException     if creating the game has been interrupted.
     */
    SSPGameImpl(final int id, final SSPState initialState, final Map<String, SSPStrategy> strategies,
            final long maxComputationTimePerMove, final SSPMoveChecker moveChecker,
            final ObserverFactoryProvider observerFactoryProvider)
            throws IllegalArgumentException, InterruptedException {

        super(id, initialState, strategies, maxComputationTimePerMove, moveChecker, observerFactoryProvider);
        this.moveFactory = new SSPDefaultMoveFactory();
    }

    @Override
    public Optional<SSPMove> chooseRandomMove(final SSPPlayer player, final SSPState state) {
        // choose "no" to punish lame strategies
        return Optional.of(this.moveFactory.createPapierMove());
    }

    @Override
    public String toString() {
        return String.format("SSPGame[id=%d, %s]", this.getId(), this.gameToString());
    }
}
