/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.tictactoe.gui.impl;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.gui.GuiObserver;
import de.fhdw.gaming.ipspiel22.tictactoe.core.domain.TicTacToeGame;
import de.fhdw.gaming.ipspiel22.tictactoe.gui.TicTacToeBoardEventProvider;
import de.fhdw.gaming.ipspiel22.tictactoe.gui.impl.TicTacToeBoardEventProviderImpl;
import de.fhdw.gaming.ipspiel22.tictactoe.gui.impl.TicTacToeBoardView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.Node;

final class TicTacToeGuiObserverImpl
implements GuiObserver {
    private static final AtomicReference<WeakReference<TicTacToeGuiObserverImpl>> INSTANCE = new AtomicReference();
    private final Map<Integer, TicTacToeBoardView> boardViews;

    TicTacToeGuiObserverImpl() {
        INSTANCE.compareAndSet(null, new WeakReference<TicTacToeGuiObserverImpl>(this));
        this.boardViews = new LinkedHashMap<Integer, TicTacToeBoardView>();
    }

    static Optional<TicTacToeBoardEventProvider> getEventProvider(int gameId) {
        TicTacToeGuiObserverImpl instance = Optional.ofNullable(INSTANCE.get()).map(Reference::get).orElse(null);
        if (instance == null) {
            return Optional.empty();
        }
        TicTacToeBoardView boardView = instance.boardViews.get(gameId);
        return boardView == null ? Optional.empty() : Optional.of(new TicTacToeBoardEventProviderImpl(boardView));
    }

    public Optional<Node> gameCreated(Game<?, ?, ?, ?> game) {
        if (game instanceof TicTacToeGame) {
            TicTacToeBoardView boardView = new TicTacToeBoardView((TicTacToeGame)game);
            this.boardViews.put(game.getId(), boardView);
            return Optional.of(boardView.getNode());
        }
        return Optional.empty();
    }

    public void gamePaused(Game<?, ?, ?, ?> game) {
        TicTacToeBoardView boardView;
        if (game instanceof TicTacToeGame && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gamePaused((TicTacToeGame)game);
        }
    }

    public void gameResumed(Game<?, ?, ?, ?> game) {
        TicTacToeBoardView boardView;
        if (game instanceof TicTacToeGame && (boardView = this.boardViews.get(game.getId())) != null) {
            boardView.gameResumed((TicTacToeGame)game);
        }
    }

    public void gameDestroyed(Game<?, ?, ?, ?> game) {
        TicTacToeBoardView boardView;
        if (game instanceof TicTacToeGame && (boardView = this.boardViews.remove(game.getId())) != null) {
            boardView.destroy((TicTacToeGame)game);
        }
    }
}

