package de.fhdw.gaming.ipspiel22.vierGewinnt.gui.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Optional;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicReference;

import de.fhdw.gaming.core.domain.Game;
import de.fhdw.gaming.gui.GuiObserver;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGGame;
import de.fhdw.gaming.ipspiel22.vierGewinnt.gui.VierGewinntBoardEventProvider;
import javafx.scene.Node;

/**
 * Implements {@link GuiObserver}.
 */
final class VierGewinntGuiOberserverImpl implements GuiObserver {

    /**
     * The primary (i.e. first created) {@link VierGewinntGuiOberserverImpl} instance of this class.
     */
    private static final AtomicReference<WeakReference<VierGewinntGuiOberserverImpl>> INSTANCE = new 
        AtomicReference<>();

    /**
     * The {@link VierGewinntBoardView} objects per connect-4 game ID.
     */
    private final Map<Integer, VierGewinntBoardView> boardViews;
    
    /**
     * Creates a {@link VierGewinntObserverImpl}.
     */
    public VierGewinntGuiOberserverImpl() {
        VierGewinntGuiOberserverImpl.INSTANCE.compareAndSet(null, new WeakReference<>(this));
        this.boardViews = new LinkedHashMap<>();
    }
    
    /**
     * Returns a {@link VierGewinntBoardEventProvider} for a given game.
     * 
     * @param gameId The game ID.
     * @return The {@link VierGewinntBoardEventProvider}.
     */
    static Optional<VierGewinntBoardEventProvider> getEventProvider(final int gameId) {
        final VierGewinntGuiOberserverImpl instance = 
                Optional.ofNullable(VierGewinntGuiOberserverImpl.INSTANCE.get())
                .map(Reference::get).orElse(null);
        if (instance == null) {
            return Optional.empty();
        } else {
            final VierGewinntBoardView boardView = instance.boardViews.get(gameId);
            return boardView == null ? Optional.empty() : Optional.of(new 
                    VierGewinntBoardEventProviderImpl(boardView));
        }
    }
    
    @Override
    public Optional<Node> gameCreated(final Game<?, ?, ?, ?> game) {
        if (game instanceof VGGame) {
            final VierGewinntBoardView boardView = new VierGewinntBoardView((VGGame) game);
            this.boardViews.put(game.getId(), boardView);
            return Optional.of(boardView.getNode());
        } else {
            return Optional.empty();
        }
    }

    @Override
    public void gamePaused(final Game<?, ?, ?, ?> game) {
        if (game instanceof VGGame) {
            final VierGewinntBoardView boardView = this.boardViews.get(game.getId());
            if (boardView != null) {
                boardView.gamePaused((VGGame) game);
            }
        }
    }

    @Override
    public void gameResumed(final Game<?, ?, ?, ?> game) {
        if (game instanceof VGGame) {
            final VierGewinntBoardView boardView = this.boardViews.get(game.getId());
            if (boardView != null) {
                boardView.gameResumed((VGGame) game);
            }
        }
    }

    @Override
    public void gameDestroyed(final Game<?, ?, ?, ?> game) {
        if (game instanceof VGGame) {
            final VierGewinntBoardView boardView = this.boardViews.get(game.getId());
            if (boardView != null) {
                boardView.destroy((VGGame) game);
            }
        }
        
    }

}
