package de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGAnswerEnum;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;

/**
 * Choosing Seventh Column.
 */
public class VG7ColumnMove extends AbstractVGMove {

    @Override
    public void applyTo(final VGState state, final VGPlayer player) throws GameException {
        state.getBoard().getNextFieldInColumn(VGAnswerEnum.SEVENTHCOLUMN).placeToken(player.isUsingRedChips());
    }

    @Override
    public String toString() {
        return "Seventh Column";
    }

    @Override
    public int getColumnInt() {
        return 7;
    }
}
