/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGAnswerEnum;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGFieldState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPosition;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.AbstractVGMove;
import java.util.Objects;

final class VGPlaceTokenMove
extends AbstractVGMove {
    private final boolean placingRedToken;
    private final VGPosition tokenPosition;

    VGPlaceTokenMove(boolean placingRedToken, VGPosition tokenPosition) {
        this.placingRedToken = placingRedToken;
        this.tokenPosition = Objects.requireNonNull(tokenPosition, "tokenPosition");
    }

    boolean isPlacingRedToken() {
        return this.placingRedToken;
    }

    VGPosition getTokenPosition() {
        return this.tokenPosition;
    }

    public void applyTo(VGState state, VGPlayer player) throws GameException {
        if (this.isPlacingRedToken() != player.isUsingRedChips()) {
            throw new GameException(String.format("Player %s cannot place a %s token.", new Object[]{player, this.isPlacingRedToken() ? VGFieldState.RED : VGFieldState.YELLOW}));
        }
        state.getBoard().getNextFieldInColumn(this.toAnswerEnum()).placeToken(player.isUsingRedChips());
    }

    private VGAnswerEnum toAnswerEnum() {
        if (this.tokenPosition.getColumn() == 0) {
            return VGAnswerEnum.FIRSTCOLUMN;
        }
        if (this.tokenPosition.getColumn() == 1) {
            return VGAnswerEnum.SECONDCOLUMN;
        }
        if (this.tokenPosition.getColumn() == 2) {
            return VGAnswerEnum.THIRDCOLUMN;
        }
        if (this.tokenPosition.getColumn() == 3) {
            return VGAnswerEnum.FOURTHCOLUMN;
        }
        if (this.tokenPosition.getColumn() == 4) {
            return VGAnswerEnum.FITFHCOLUMN;
        }
        if (this.tokenPosition.getColumn() == 5) {
            return VGAnswerEnum.SIXTHCOLUMN;
        }
        return VGAnswerEnum.SEVENTHCOLUMN;
    }

    public String toString() {
        return String.format("Placing %s token on field at %s", this.placingRedToken ? "red" : "yellow", this.tokenPosition);
    }

    @Override
    public int getColumnInt() {
        return 0;
    }
}

