package de.fhdw.gaming.ipspiel22.vierGewinnt.domain;

/**
 * Represents a field position on a board. It contains a column number and a row number.
 */
public final class VGPosition {

    /**
     * The column index.
     */
    private final int column;
    /**
     * The column index.
     */
    private final int row;

    /**
     * Creates a position on an VG board.
     *
     * @param column    The column number.
     * @param row The row number.
     */
    public VGPosition(final int column, final int row) {
        this.column = column;
        this.row = row;
    }

    /**
     * Creates a position on an VG board.
     *
     * @param column    The column number.
     * @param row The row number.
     * @return The position.
     */
    public static VGPosition of(final int column, final int row) {
        return new VGPosition(column, row);
    }

    /**
     * Returns the column number.
     */
    public int getColumn() {
        return this.column;
    }

    /**
     * Returns the row number.
     */
    public int getRow() {
        return this.row;
    }

    @Override
    public String toString() {
        return String.format("%c%d", (char) (this.row + 'A'), this.column + 1);
    }

    @Override
    public int hashCode() {
        return this.column ^ this.row;
    }

    @Override
    public boolean equals(final Object obj) {
        if (obj instanceof VGPosition) {
            final VGPosition other = (VGPosition) obj;
            return this.column == other.column && this.row == other.row;
        }
        return false;
    }
}
