/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl;

import de.fhdw.gaming.core.domain.DefaultObserverFactoryProvider;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGGame;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGGameBuilder;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayerBuilder;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGStrategy;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl.VGBoardImpl;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl.VGGameImpl;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl.VGPlayerBuilderImpl;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl.VGStateImpl;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.AbstractVGMove;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Optional;

public class VGGameBuilderImpl
implements VGGameBuilder {
    private ObserverFactoryProvider observerFactoryProvider = new DefaultObserverFactoryProvider();
    private Optional<VGPlayer> redPlayer = Optional.empty();
    private Optional<VGStrategy> redPlayerStrategy = Optional.empty();
    private Optional<VGPlayer> yellowPlayer = Optional.empty();
    private Optional<VGStrategy> yellowPlayerStrategy = Optional.empty();
    private int maxComputationTimePerMove = 5;

    @Override
    public VGPlayerBuilder createPlayerBuilder() {
        return new VGPlayerBuilderImpl();
    }

    @Override
    public VGGameBuilder addPlayer(VGPlayer player, VGStrategy strategy) throws GameException {
        if (player.isUsingRedChips() && this.redPlayer.isEmpty()) {
            this.redPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.redPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "redPlayerStrategy"));
        } else if (!player.isUsingRedChips() && this.yellowPlayer.isEmpty()) {
            this.yellowPlayer = Optional.of(Objects.requireNonNull(player, "player"));
            this.yellowPlayerStrategy = Optional.of(Objects.requireNonNull(strategy, "yellowPlayerStrategy"));
        } else {
            throw new GameException(String.format("More than two players are now allowed.", new Object[0]));
        }
        return this;
    }

    public VGGameBuilder changeMaximumComputationTimePerMove(int newMaxComputationTimePerMove) {
        this.maxComputationTimePerMove = newMaxComputationTimePerMove;
        return this;
    }

    @Override
    public VGGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider) {
        this.observerFactoryProvider = newObserverFactoryProvider;
        return this;
    }

    @Override
    public VGGame build(int id) throws GameException, InterruptedException {
        if (!this.redPlayer.isPresent() || !this.yellowPlayer.isPresent()) {
            throw new GameException("A Vier gewinnt game needs two players.");
        }
        VGBoardImpl board = new VGBoardImpl();
        VGStateImpl initialState = new VGStateImpl(board, this.redPlayer.get(), this.yellowPlayer.get(), true);
        LinkedHashMap<String, VGStrategy> strategies = new LinkedHashMap<String, VGStrategy>();
        strategies.put(initialState.getRedPlayer().getName(), this.redPlayerStrategy.orElseThrow());
        strategies.put(initialState.getYellowPlayer().getName(), this.yellowPlayerStrategy.orElseThrow());
        return new VGGameImpl(id, initialState, strategies, this.maxComputationTimePerMove, AbstractVGMove.class::isInstance, this.observerFactoryProvider);
    }

    public ObserverFactoryProvider getObserverFactoryProvider() {
        return this.observerFactoryProvider;
    }

    public int getMaxComputationTimePerMove() {
        return this.maxComputationTimePerMove;
    }
}

