package de.fhdw.gaming.ipspiel22.vierGewinnt.domain.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGGame;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGMoveChecker;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGStrategy;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.VGMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.factory.VGMoveFactory;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.impl.VGDefaultMoveFactory;

/**
 * Implements the Vier gewinnt game.
 */
public class VGGameImpl extends DefaultGame<VGPlayer, VGState, VGMove, VGStrategy> implements VGGame {
    /**
     * For choosing a random column.
     */
    private static final Random RANDOM = new Random();
    
    /**
     * The move factory.
     */
    private final VGMoveFactory moveFactory;

    /**
     * Creates a Vier gewinnt game.
     *
     * @param id                        The ID of this game.
     * @param initialState              The initial state of the game.
     * @param strategies                The players' strategies.
     * @param maxComputationTimePerMove The maximum computation time per move in seconds.
     * @param moveChecker               The move checker.
     * @param observerFactoryProvider   The {@link ObserverFactoryProvider}.
     * @throws IllegalArgumentException if the player sets do not match.
     * @throws InterruptedException     if creating the game has been interrupted.
     */
    VGGameImpl(final int id, final VGState initialState, final Map<String, VGStrategy> strategies,
            final long maxComputationTimePerMove, final VGMoveChecker moveChecker,
            final ObserverFactoryProvider observerFactoryProvider)
            throws IllegalArgumentException, InterruptedException {

        super(id, initialState, strategies, maxComputationTimePerMove, moveChecker, observerFactoryProvider);
        this.moveFactory = new VGDefaultMoveFactory();
    }

    @Override
    public Optional<VGMove> chooseRandomMove(final VGPlayer player, final VGState state) {
        final List<VGMove> movesList = Arrays.asList(this.moveFactory.createFirstColumnMove(),
                this.moveFactory.createSecondColumnMove(),
                this.moveFactory.createThirdColumnMove(),
                this.moveFactory.createFourthColumnMove(),
                this.moveFactory.createFifthColumnMove(),
                this.moveFactory.createSixthColumnMove(),
                this.moveFactory.createSeventhColumnMove());
        final int index = RANDOM.nextInt(movesList.size() - 1);
        return Optional.of(movesList.get(index)); //TODO anschauen
    }

    @Override
    public String toString() {
        return String.format("VGGame[id=%d, %s]", this.getId(), this.gameToString());
    }
}
