/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.vierGewinnt.strategy;

import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGAnswerEnum;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGField;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGPlayer;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGState;
import de.fhdw.gaming.ipspiel22.vierGewinnt.domain.VGStrategy;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.VGMove;
import de.fhdw.gaming.ipspiel22.vierGewinnt.moves.factory.VGMoveFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;

public class VGRandomMoveStrategy
implements VGStrategy {
    private static final Random RANDOM = new Random();
    private final List<VGMove> movesList;
    private final VGMove firstColumn;
    private final VGMove secondColumn;
    private final VGMove thirdColumn;
    private final VGMove fourthColumn;
    private final VGMove fifthColumn;
    private final VGMove sixthColumn;
    private final VGMove seventhColumn;

    public VGRandomMoveStrategy(VGMoveFactory moveFactory) {
        this.firstColumn = moveFactory.createFirstColumnMove();
        this.secondColumn = moveFactory.createSecondColumnMove();
        this.thirdColumn = moveFactory.createThirdColumnMove();
        this.fourthColumn = moveFactory.createFourthColumnMove();
        this.fifthColumn = moveFactory.createFifthColumnMove();
        this.sixthColumn = moveFactory.createSixthColumnMove();
        this.seventhColumn = moveFactory.createSeventhColumnMove();
        this.movesList = new ArrayList<VGMove>(Arrays.asList(this.firstColumn, this.secondColumn, this.thirdColumn, this.fourthColumn, this.fifthColumn, this.sixthColumn, this.seventhColumn));
    }

    public Optional<VGMove> computeNextMove(int gameId, VGPlayer player, VGState state) {
        this.checkFirstColumn(state.getBoard().getNextFieldInColumn(VGAnswerEnum.FIRSTCOLUMN));
        this.checkSecondColumn(state.getBoard().getNextFieldInColumn(VGAnswerEnum.SECONDCOLUMN));
        this.checkThirdColumn(state.getBoard().getNextFieldInColumn(VGAnswerEnum.THIRDCOLUMN));
        this.checkFourthColumn(state.getBoard().getNextFieldInColumn(VGAnswerEnum.FOURTHCOLUMN));
        this.checkFifthColumn(state.getBoard().getNextFieldInColumn(VGAnswerEnum.FITFHCOLUMN));
        this.checkSixthColumn(state.getBoard().getNextFieldInColumn(VGAnswerEnum.SIXTHCOLUMN));
        this.checkSeventhColumn(state.getBoard().getNextFieldInColumn(VGAnswerEnum.SEVENTHCOLUMN));
        int index = RANDOM.nextInt(this.movesList.size());
        return Optional.of(this.movesList.get(index));
    }

    private void checkFirstColumn(VGField vgField) {
        if (this.movesList.contains(this.firstColumn) && Objects.isNull(vgField)) {
            this.movesList.remove(this.firstColumn);
        }
    }

    private void checkSecondColumn(VGField vgField) {
        if (this.movesList.contains(this.secondColumn) && Objects.isNull(vgField)) {
            this.movesList.remove(this.secondColumn);
        }
    }

    private void checkThirdColumn(VGField vgField) {
        if (this.movesList.contains(this.thirdColumn) && Objects.isNull(vgField)) {
            this.movesList.remove(this.thirdColumn);
        }
    }

    private void checkFourthColumn(VGField vgField) {
        if (this.movesList.contains(this.fourthColumn) && Objects.isNull(vgField)) {
            this.movesList.remove(this.fourthColumn);
        }
    }

    private void checkFifthColumn(VGField vgField) {
        if (this.movesList.contains(this.fifthColumn) && Objects.isNull(vgField)) {
            this.movesList.remove(this.fifthColumn);
        }
    }

    private void checkSixthColumn(VGField vgField) {
        if (this.movesList.contains(this.sixthColumn) && Objects.isNull(vgField)) {
            this.movesList.remove(this.sixthColumn);
        }
    }

    private void checkSeventhColumn(VGField vgField) {
        if (this.movesList.contains(this.seventhColumn) && Objects.isNull(vgField)) {
            this.movesList.remove(this.seventhColumn);
        }
    }

    public String toString() {
        return VGRandomMoveStrategy.class.getSimpleName();
    }
}

