package de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.impl;

import java.util.Map;
import java.util.Optional;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDGame;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDMoveChecker;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDPlayer;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDState;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.domain.GDStrategy;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.moves.GDMove;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.moves.factory.GDMoveFactory;
import de.fhdw.gaming.ipspiel22.gefangenenDilemma.moves.impl.GDDefaultMoveFactory;

/**
 * Implements the Gefangenen Dilemma game.
 */
public class GDGameImpl extends DefaultGame<GDPlayer, GDState, GDMove, GDStrategy> implements GDGame {

    /**
     * The move factory.
     */
    private final GDMoveFactory moveFactory;

    /**
     * Creates a Gefangenen Dilemma game.
     *
     * @param id                        The ID of this game.
     * @param initialState              The initial state of the game.
     * @param strategies                The players' strategies.
     * @param maxComputationTimePerMove The maximum computation time per move in seconds.
     * @param moveChecker               The move checker.
     * @param observerFactoryProvider   The {@link ObserverFactoryProvider}.
     * @throws IllegalArgumentException if the player sets do not match.
     * @throws InterruptedException     if creating the game has been interrupted.
     */
    GDGameImpl(final int id, final GDState initialState, final Map<String, GDStrategy> strategies,
            final long maxComputationTimePerMove, final GDMoveChecker moveChecker,
            final ObserverFactoryProvider observerFactoryProvider)
            throws IllegalArgumentException, InterruptedException {

        super(id, initialState, strategies, maxComputationTimePerMove, moveChecker, observerFactoryProvider);
        this.moveFactory = new GDDefaultMoveFactory();
    }

    @Override
    public Optional<GDMove> chooseRandomMove(final GDPlayer player, final GDState state) {
        // choose "statement" to punish lame strategies
        return Optional.of(this.moveFactory.createStatementMove());
    }

    @Override
    public String toString() {
        return String.format("GDGame[id=%d, %s]", this.getId(), this.gameToString());
    }
}
