/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel22.searchtree.algorithm;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel22.searchtree.domain.MinMaxGame;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class MinMaxAlgorithm<P extends Player<P>, S extends State<P, S>, M extends Move<P, S>, G extends MinMaxGame<P, S, M>> {
    private final G game;

    public MinMaxAlgorithm(G game) {
        this.game = game;
    }

    public Optional<M> getBestMove(int depth) throws GameException {
        if (this.game.isGameOver()) {
            return Optional.empty();
        }
        LinkedHashMap<Move, Double> scores = new LinkedHashMap<Move, Double>();
        for (Move move : this.game.getPossibleMoves()) {
            this.game.commitMove((Move)move);
            scores.put(move, -this.miniMax(depth, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            this.game.rollbackMove((Move)move);
        }
        return scores.entrySet().stream().max((e1, e2) -> ((Double)e1.getValue()).compareTo((Double)e2.getValue())).map(Map.Entry::getKey);
    }

    public double miniMax(int depth, double alpha, double beta) throws GameException {
        if (depth == 0 || this.game.isGameOver()) {
            return this.game.evaluateStateful();
        }
        double maxWert = alpha;
        List moves = this.game.getPossibleMoves();
        for (Move move : moves) {
            this.game.commitMove((Move)move);
            double wert = -this.miniMax(depth - 1, -beta, -maxWert);
            this.game.rollbackMove((Move)move);
            if (!(wert > maxWert) || !((maxWert = wert) >= beta)) continue;
            break;
        }
        return maxWert;
    }
}

