package de.fhdw.gaming.ipspiel22.kopfundzahl.domain;

import de.fhdw.gaming.core.domain.GameBuilder;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;

/**
 * A builder which allows to create a Head and Tail game.
 */
public interface KopfundZahlGameBuilder extends GameBuilder {

    /**
     * Creates an {@link KopfundZahlPlayerBuilder} which allows to create and add a player to the game together with
     * their
     * strategy.
     */
    KopfundZahlPlayerBuilder createPlayerBuilder();

    /**
     * Adds a player and her corresponding strategy.
     *
     * @param player   The player.
     * @param strategy The player's strategy.
     * @throws GameException if adding the player is not allowed by the rules of the game.
     */
    KopfundZahlGameBuilder addPlayer(KopfundZahlPlayer player,
            KopfundZahlStrategy strategy) throws GameException;

    /**
     * Changes the {@link ObserverFactoryProvider}.
     *
     * @param newObserverFactoryProvider The new {@link ObserverFactoryProvider}.
     * @return {@code this}
     */

    KopfundZahlGameBuilder changeObserverFactoryProvider(ObserverFactoryProvider newObserverFactoryProvider);

    @Override
    KopfundZahlGame build(int id) throws GameException, InterruptedException;
}
