package de.fhdw.gaming.ipspiel22.kopfundzahl.domain;

import java.util.Map;

import de.fhdw.gaming.core.domain.GameException;

/**
 * A builder which allows to create a Head and Tail player.
 */
public interface KopfundZahlPlayerBuilder {

    /**
     * Changes the name of the player.
     * <p>
     * There is no default.
     *
     * @param newName The name of the player.
     * @return {@code this}
     */
    KopfundZahlPlayerBuilder changeName(String newName);

    /**
     * Changes the possible outcomes of the player.
     * <p>
     * There is no default.
     *
     * @param possibleOutcomes The possible outcomes of the player. The key for the first-level map is the answer of the
     *                         first player, the key for the second-level map is the answer of the second player.
     */
    KopfundZahlPlayerBuilder changePossibleOutcomes(Map<Boolean, Map<Boolean, Double>> possibleOutcomes);

    /**
     * Builds the player.
     *
     * @return The KopfundZahl player.
     * @throws GameException if creating the player is not allowed by the rules of the game.
     */
    KopfundZahlPlayer build() throws GameException;
}
