package de.fhdw.gaming.ipspiel22.kopfundzahl.domain;

import de.fhdw.gaming.core.domain.GameBuilderFactory;
import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.ui.InputProvider;

/**
 * A Demo {@link GameBuilderFactory} which allows to create a KopfundZahl game builder.
 */
public interface KopfundZahlGameBuilderFactory extends GameBuilderFactory {

    /**
     * Player's outcome on no/no.
     */
    String PARAM_PLAYER_OUTCOME_ON_TAIL_TAIL = "playerOutcomeOnTailTail";

    /**
     * Player's outcome on no/yes.
     */
    String PARAM_PLAYER_OUTCOME_ON_TAIL_HEAD = "playerOutcomeOnTailHead";

    /**
     * Player's outcome on no/no.
     */
    String PARAM_PLAYER_OUTCOME_ON_HEAD_TAIL = "playerOutcomeOnHeadTail";

    /**
     * Player's outcome on no/yes.
     */
    String PARAM_PLAYER_OUTCOME_ON_HEAD_HEAD = "playerOutcomeOnHeadHead";

    @Override
    KopfundZahlGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException;
}
