/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.MoveChecker;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Game;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4MoveChecker;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4State;
import de.fhdw.gaming.ipspiel23.c4.moves.IC4Move;
import de.fhdw.gaming.ipspiel23.c4.moves.factory.IC4MoveFactory;
import de.fhdw.gaming.ipspiel23.c4.moves.impl.C4DefaultMoveFactory;
import de.fhdw.gaming.ipspiel23.c4.strategies.IC4Strategy;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

public class C4Game
extends DefaultGame<IC4Player, IC4State, IC4Move, IC4Strategy>
implements IC4Game {
    private static final Random RANDOM = new Random();
    private final IC4MoveFactory moveFactory = new C4DefaultMoveFactory();

    public C4Game(int id, IC4State initialState, Map<String, IC4Strategy> strategies, long maxComputationTimePerMove, IC4MoveChecker moveChecker, ObserverFactoryProvider observerFactoryProvider) throws IllegalArgumentException, InterruptedException {
        super(id, (State)initialState, strategies, maxComputationTimePerMove, (MoveChecker)moveChecker, observerFactoryProvider);
    }

    public Optional<IC4Move> chooseRandomMove(IC4Player player, IC4State state) {
        IC4Position[] positions = state.getBoard().getLegalPositions();
        if (positions.length == 0) {
            return Optional.empty();
        }
        int index = RANDOM.nextInt(positions.length);
        IC4Position position = positions[index];
        return Optional.of(this.moveFactory.createMove(player, position));
    }
}

