package de.fhdw.gaming.ipspiel23.gst.domain;

import de.fhdw.gaming.core.domain.Move;
import de.fhdw.gaming.core.domain.Player;
import de.fhdw.gaming.core.domain.State;
import de.fhdw.gaming.ipspiel23.gst.strategies.domain.IGstKopplungsMiniMaxStrategy;

/**
 * A calculator interface for calculating the next move in a game.
 * The calculator takes the current game state, maximum computation time, and a mini-max strategy as inputs.
 * It returns the calculated move for the player in the given state.
 *
 * @param <P> The type of player in the game.
 * @param <S> The type of state in the game.
 */
public interface ICalculatorKopplung<P extends Player<P>, S extends State<P, S>> {
    
    /**
     * Calculates the next best move for the current Player in the game.
     *
     * @param kopplung               The game object representing the specific game being played.
     * @param state                  The current state of the game.
     * @param maximumComputationTime The maximum computation time allowed for calculating the move (in seconds).
     * @param strategy               The mini-max strategy used for calculating the move.
     * @return The calculated move for the player in the given state.
     */
    Move<P, S> calculateMove(IKopplung<P, S> kopplung, S state, Integer maximumComputationTime,
            IGstKopplungsMiniMaxStrategy<P, S> strategy);
}
