/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.demo.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.core.domain.Strategy;
import de.fhdw.gaming.core.ui.InputProvider;
import de.fhdw.gaming.core.ui.InputProviderException;
import de.fhdw.gaming.core.ui.type.validator.MaxValueValidator;
import de.fhdw.gaming.core.ui.type.validator.MinValueValidator;
import de.fhdw.gaming.core.ui.type.validator.PatternValidator;
import de.fhdw.gaming.core.ui.type.validator.Validator;
import de.fhdw.gaming.ipspiel23.demo.domain.DemoGameBuilder;
import de.fhdw.gaming.ipspiel23.demo.domain.DemoGameBuilderFactory;
import de.fhdw.gaming.ipspiel23.demo.domain.DemoPlayer;
import de.fhdw.gaming.ipspiel23.demo.domain.DemoPlayerBuilder;
import de.fhdw.gaming.ipspiel23.demo.domain.DemoStrategy;
import de.fhdw.gaming.ipspiel23.demo.domain.factory.DemoDefaultStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel23.demo.domain.factory.DemoStrategyFactory;
import de.fhdw.gaming.ipspiel23.demo.domain.factory.DemoStrategyFactoryProvider;
import de.fhdw.gaming.ipspiel23.demo.domain.impl.DemoGameBuilderImpl;
import de.fhdw.gaming.ipspiel23.demo.moves.impl.DemoDefaultMoveFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public final class DemoGameBuilderFactoryImpl
implements DemoGameBuilderFactory {
    private static final int NUMBER_OF_PLAYERS = 2;
    private static final int MIN_MAX_COMPUTATION_TIME_PER_MOVE = 1;
    private static final int MAX_MAX_COMPUTATION_TIME_PER_MOVE = 3600;
    private final Set<DemoStrategy> strategies;

    public DemoGameBuilderFactoryImpl() {
        this(new DemoDefaultStrategyFactoryProvider());
    }

    DemoGameBuilderFactoryImpl(DemoStrategyFactoryProvider strategyFactoryProvider) {
        DemoDefaultMoveFactory moveFactory = new DemoDefaultMoveFactory();
        List<DemoStrategyFactory> factories = strategyFactoryProvider.getStrategyFactories();
        this.strategies = new LinkedHashSet<DemoStrategy>();
        for (DemoStrategyFactory factory : factories) {
            this.strategies.add(factory.create(moveFactory));
        }
    }

    public String getName() {
        return "Demo";
    }

    public int getMinimumNumberOfPlayers() {
        return 2;
    }

    public int getMaximumNumberOfPlayers() {
        return 2;
    }

    public List<? extends Strategy<?, ?, ?>> getStrategies() {
        return new ArrayList<DemoStrategy>(this.strategies);
    }

    @Override
    public DemoGameBuilder createGameBuilder(InputProvider inputProvider) throws GameException {
        try {
            DemoGameBuilderImpl gameBuilder = new DemoGameBuilderImpl();
            Map gameData = inputProvider.needInteger("maxComputationTimePerMove", "Maximum computation time per move in seconds", Optional.of(5), new Validator[]{new MinValueValidator((Comparable)Integer.valueOf(1)), new MaxValueValidator((Comparable)Integer.valueOf(3600))}).requestData("Game properties");
            gameBuilder.changeMaximumComputationTimePerMove((Integer)gameData.get("maxComputationTimePerMove"));
            InputProvider firstPlayerInputProvider = inputProvider.getNext(gameData);
            Map<String, Object> firstPlayerData = this.requestPlayerData(firstPlayerInputProvider, "Player 1");
            DemoPlayer firstPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), firstPlayerData);
            DemoStrategy firstPlayerStrategy = this.getStrategy(firstPlayerData);
            gameBuilder.addPlayer(firstPlayer, firstPlayerStrategy);
            InputProvider secondPlayerInputProvider = firstPlayerInputProvider.getNext(firstPlayerData);
            Map<String, Object> secondPlayerData = this.requestPlayerData(secondPlayerInputProvider, "Player 2");
            DemoPlayer secondPlayer = this.createPlayer(gameBuilder.createPlayerBuilder(), secondPlayerData);
            DemoStrategy secondPlayerStrategy = this.getStrategy(secondPlayerData);
            gameBuilder.addPlayer(secondPlayer, secondPlayerStrategy);
            return gameBuilder;
        }
        catch (InputProviderException e) {
            throw new GameException(String.format("Creating Demo game was aborted: %s", e.getMessage()), (Throwable)e);
        }
    }

    private Map<String, Object> requestPlayerData(InputProvider inputProvider, String title) throws GameException, InputProviderException {
        inputProvider.needString("playerName", "Name", Optional.empty(), new Validator[]{new PatternValidator(Pattern.compile("\\S+(\\s+\\S+)*"))}).needInteger("playerOutcomeOnNoNo", "Player's outcome on No/No", Optional.of(-1), new Validator[0]).needInteger("playerOutcomeOnNoYes", "Player's outcome on No/Yes", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnYesNo", "Player's outcome on Yes/No", Optional.of(0), new Validator[0]).needInteger("playerOutcomeOnYesYes", "Player's outcome on Yes/Yes", Optional.of(1), new Validator[0]).needObject("playerStrategy", "Strategy", Optional.empty(), this.strategies);
        return inputProvider.requestData(title);
    }

    private DemoPlayer createPlayer(DemoPlayerBuilder playerBuilder, Map<String, Object> playerData) throws GameException, InputProviderException {
        LinkedHashMap<Boolean, Map<Boolean, Double>> possibleOutcomes = new LinkedHashMap<Boolean, Map<Boolean, Double>>();
        LinkedHashMap<Boolean, Double> possibleOutcomesNo = new LinkedHashMap<Boolean, Double>();
        possibleOutcomesNo.put(Boolean.FALSE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnNoNo")).intValue()));
        possibleOutcomesNo.put(Boolean.TRUE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnNoYes")).intValue()));
        possibleOutcomes.put(Boolean.FALSE, possibleOutcomesNo);
        LinkedHashMap<Boolean, Double> possibleOutcomesYes = new LinkedHashMap<Boolean, Double>();
        possibleOutcomesYes.put(Boolean.FALSE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnYesNo")).intValue()));
        possibleOutcomesYes.put(Boolean.TRUE, Double.valueOf(((Integer)playerData.get("playerOutcomeOnYesYes")).intValue()));
        possibleOutcomes.put(Boolean.TRUE, possibleOutcomesYes);
        return playerBuilder.changeName((String)playerData.get("playerName")).changePossibleOutcomes(possibleOutcomes).build();
    }

    private DemoStrategy getStrategy(Map<String, Object> playerData) {
        return (DemoStrategy)playerData.get("playerStrategy");
    }
}

