package de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.impl;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;

import de.fhdw.gaming.core.domain.DefaultGame;
import de.fhdw.gaming.core.domain.MoveChecker;
import de.fhdw.gaming.core.domain.ObserverFactoryProvider;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgGame;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgPlayer;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgState;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgStrategy;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.Answer;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.factory.AnswerFactory;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.impl.AnswerFactoryImpl;

/**
 * Implements {@link FzgGame}.
 *
 */
public class FzgGameImpl extends DefaultGame<FzgPlayer, FzgState, Answer, FzgStrategy> implements FzgGame {

    /**
     * AnswerFactory.
     */
    private final AnswerFactory answerFactory;

    /**
     * Constructor, creates a FzgGame.
     * 
     * @param id                        The ID of this game.
     * @param initialState              The initial state of the game.
     * @param strategies                The players' strategies.
     * @param maxComputationTimePerMove The maximum computation time per move in seconds.
     * @param moveChecker               The move checker.
     * @param observerFactoryProvider   The {@link ObserverFactoryProvider}.
     * @throws IllegalArgumentException if the player sets do not match.
     * @throws InterruptedException     if creating the game has been interrupted.
     */
    public FzgGameImpl(final int id, final FzgState initialState, final Map<String, FzgStrategy> strategies,
            final long maxComputationTimePerMove,
            final MoveChecker<FzgPlayer, FzgState, Answer> moveChecker,
            final ObserverFactoryProvider observerFactoryProvider)
            throws IllegalArgumentException, InterruptedException {
        super(id, initialState, strategies, maxComputationTimePerMove, moveChecker, observerFactoryProvider);
        this.answerFactory = new AnswerFactoryImpl();
    }

    @Override
    public Optional<Answer> chooseRandomMove(final FzgPlayer player, final FzgState state) {
        // 50/50 if Cinema or Football.
        // No specific strategy chosen, as one player is not trying to compete against the other.
        if (ThreadLocalRandom.current().nextBoolean()) {
            return Optional.of(this.answerFactory.createCinemaAnswer());
        }
        return Optional.of(this.answerFactory.createFootballAnswer());
    }

    @Override
    public String toString() {
        return String.format("FzgGame[id=%d, %s]", this.getId(), this.gameToString());
    }
}
