package de.fhdw.gaming.ipspiel23.dilemma.moves.internals;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;

/**
 * Represents a move allowed by the rules of the game.
 * <p>
 * The purpose of this class is to be able to check whether a {@link IDilemmaMove} implementation is allowed by the
 * rules of the game. As this class is not public, custom strategies are unable to create {@link IDilemmaMove} objects
 * that inherit from this class, so custom moves can be distinguished from possible moves easily.
 * </p>
 */
public abstract class DilemmaMove implements IDilemmaMove {
    
    /**
     * Protected constructor.
     */
    protected DilemmaMove() {
        // nothing to do
    }

    @Override
    public void applyTo(final IDilemmaState state, final IDilemmaPlayer player) throws GameException {
        player.setAnswer(getAnswer());
    }

    @Override
    public abstract DilemmaAnswerType getAnswer();

    @Override
    public boolean equals(final Object obj) {
        if (obj instanceof DilemmaMove) {
            final DilemmaMove other = (DilemmaMove) obj;
            return other.getAnswer().equals(this.getAnswer());
        }
        return false;
    }
    
    @Override
    public int hashCode() {
        return this.getAnswer().hashCode() + 31 * this.toString().hashCode();
    }
}
