/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.generous_tit_for_tat;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.dilemma.domain.DilemmaAnswerType;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaPlayer;
import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaState;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMove;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaMemoryStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.DilemmaRoundData;
import de.fhdw.gaming.ipspiel23.memory.GameMemoryCapacity;
import de.fhdw.gaming.ipspiel23.memory.IGameMemory;
import de.fhdw.gaming.ipspiel23.memory.IGameMemoryCapacity;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

public class DilemmaGenerousTitForTatStrategy
extends DilemmaMemoryStrategy {
    private static final Random RANDOM = new Random();

    protected DilemmaGenerousTitForTatStrategy(IDilemmaMoveFactory moveFactory) {
        super(moveFactory);
    }

    @Override
    protected IGameMemoryCapacity requestedMemoryCapacity() {
        return GameMemoryCapacity.of((Integer)1);
    }

    public Optional<IDilemmaMove> computeNextMove(int gameId, IDilemmaPlayer player, IDilemmaState state) throws GameException, InterruptedException {
        IGameMemory<DilemmaRoundData> memory = this.getMemoryForPlayer(player, state);
        IDilemmaMoveFactory moveFactory = this.getMoveFactory();
        if (memory.size() == 0) {
            return Optional.of(moveFactory.createCooperateMove());
        }
        DilemmaRoundData previousRound = (DilemmaRoundData)memory.getRound(0, true);
        IDilemmaMove otherPlayersAction = previousRound.forOpponentOf(player).move();
        if (otherPlayersAction.equals(this.getMoveFactory().createCooperateMove())) {
            return Optional.of(otherPlayersAction);
        }
        Map<DilemmaAnswerType, Map<DilemmaAnswerType, Double>> outcomes = player.getPossibleOutcomes();
        double varR = outcomes.get((Object)DilemmaAnswerType.COOPERATE).get((Object)DilemmaAnswerType.COOPERATE);
        double varS = outcomes.get((Object)DilemmaAnswerType.COOPERATE).get((Object)DilemmaAnswerType.DEFECT);
        double varT = outcomes.get((Object)DilemmaAnswerType.DEFECT).get((Object)DilemmaAnswerType.COOPERATE);
        double varP = outcomes.get((Object)DilemmaAnswerType.DEFECT).get((Object)DilemmaAnswerType.DEFECT);
        double num1 = 1.0 - (varT - varR) / (varR - varS);
        double num2 = (varR - varP) / (varT - varP);
        double probabilityForCooperation = Math.min(num1, num2);
        return Optional.of(RANDOM.nextDouble() <= probabilityForCooperation ? this.getMoveFactory().createCooperateMove() : this.getMoveFactory().createDefectMove());
    }
}

