package de.fhdw.gaming.ipspiel23.dilemma.strategy.internals.grim;

import de.fhdw.gaming.ipspiel23.dilemma.domain.IDilemmaStrategy;
import de.fhdw.gaming.ipspiel23.dilemma.moves.IDilemmaMoveFactory;
import de.fhdw.gaming.ipspiel23.dilemma.strategy.IDilemmaStrategyFactory;

/**
 * Implements {@link IDilemmaStrategyFactory} by creating a {@link DilemmaGrimStrategy}.
 */
public class DilemmaGrimStrategyFactory implements IDilemmaStrategyFactory {

    /**
     * Creates strategy which is visible for the player to chose.
     */
    @Override
    public IDilemmaStrategy create(final IDilemmaMoveFactory moveFactory) {
        return new DilemmaGrimStrategy(moveFactory);
    }
}
