/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.c4.domain.impl;

import de.fhdw.gaming.ipspiel23.c4.domain.C4PositionMaterializer;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Board;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4BoardSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Field;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Solution;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4SolutionSlim;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4Field;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.impl.C4Solution;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class C4Board
implements IC4Board {
    private static final int FIELD_CACHE_LIMIT = 65536;
    private final Map<IC4Position, IC4Field> fieldCache;
    private final IC4BoardSlim slimBoard;
    private final ThreadLocal<long[]> localPositionBuffer;

    public C4Board(IC4BoardSlim slimBoard) {
        this.slimBoard = slimBoard;
        this.fieldCache = new HashMap<IC4Position, IC4Field>(slimBoard.getBoardStateUnsafe().length);
        this.localPositionBuffer = ThreadLocal.withInitial(() -> new long[this.slimBoard.getBoardStateUnsafe().length]);
    }

    public Map<IC4Position, IC4Field> getFieldCache() {
        return this.fieldCache;
    }

    @Override
    public int getRowCount() {
        return this.slimBoard.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.slimBoard.getColumnCount();
    }

    @Override
    public int getMinimumSolutionSize() {
        return this.slimBoard.getMinimumSolutionSize();
    }

    @Override
    public IC4Board deepCopy() {
        return new C4Board(this.slimBoard.deepCopy());
    }

    @Override
    public IC4BoardSlim getInternalBoard() {
        return this.slimBoard;
    }

    @Override
    public boolean checkBounds(IC4Position position) {
        return this.checkBounds(position.getRow(), position.getColumn());
    }

    @Override
    public boolean checkBounds(int row, int column) {
        return this.slimBoard.checkBounds(row, column);
    }

    @Override
    public boolean isEmpty(IC4Position position) {
        return this.isEmpty(position.getRow(), position.getColumn());
    }

    @Override
    public boolean isEmpty(int row, int column) {
        if (!this.checkBounds(row, column)) {
            throw new IndexOutOfBoundsException("The provided position is not within the defined bounds of the board!");
        }
        return this.slimBoard.isEmptyUnsafe(row, column);
    }

    @Override
    public Optional<IC4Field> tryGetField(IC4Position position) {
        return Optional.ofNullable(this.getFieldInternal(position, false));
    }

    @Override
    public IC4Field getField(IC4Position position) {
        return this.getFieldInternal(position, true);
    }

    private IC4Field getFieldInternal(IC4Position position, boolean throwOob) {
        IC4Field field = this.fieldCache.get(position);
        if (field != null) {
            return field;
        }
        if (!this.checkBounds(position)) {
            if (throwOob) {
                throw new IndexOutOfBoundsException("The provided position violates the bounds of the board!");
            }
            return null;
        }
        field = new C4Field(this, position);
        if (this.fieldCache.size() >= 65536) {
            this.fieldCache.clear();
        }
        this.fieldCache.put(position, field);
        return field;
    }

    @Override
    public Optional<IC4Player> getOccupyingPlayerOrDefault(IC4Position position) {
        int column;
        int row = position.getRow();
        if (!this.checkBounds(row, column = position.getColumn())) {
            throw new IndexOutOfBoundsException("The provided position is not within the defined bounds of the board!");
        }
        int token = this.slimBoard.getTokenUnsafe(row, column);
        return Optional.ofNullable(this.slimBoard.getPlayerByToken(token));
    }

    @Override
    public IC4Field[][] getFields() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        IC4Field[][] fields = new C4Field[rows][cols];
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                C4Position position = new C4Position(row, col);
                fields[row][col] = this.getFieldInternal(position, false);
            }
        }
        return fields;
    }

    @Override
    public Optional<IC4Solution> tryFindFirstSolution() {
        IC4SolutionSlim slimSolution = this.slimBoard.tryFindFirstSolution(true);
        if (slimSolution == null) {
            return Optional.empty();
        }
        C4Solution solution = new C4Solution(this, slimSolution);
        return Optional.of(solution);
    }

    @Override
    public Set<IC4Solution> findAllSolutions() {
        Set<IC4SolutionSlim> slimSolutions = this.slimBoard.findAllSolutions(true);
        if (slimSolutions.isEmpty()) {
            return Set.of();
        }
        HashSet<IC4Solution> solutions = new HashSet<IC4Solution>(slimSolutions.size());
        for (IC4SolutionSlim slimSolution : slimSolutions) {
            solutions.add(new C4Solution(this, slimSolution));
        }
        return solutions;
    }

    @Override
    public boolean isSolid(IC4Position position) {
        return this.isSolid(position.getRow(), position.getColumn());
    }

    @Override
    public boolean isSolid(int row, int column) {
        if (!this.checkBounds(row, column) && !this.checkBounds(row - 1, column)) {
            throw new IndexOutOfBoundsException("The provided position is not within the defined bounds of the board!");
        }
        return this.slimBoard.isSolidUnsafe(row, column);
    }

    @Override
    public IC4Position[] getEmptyPositions() {
        return this.getPositionsByToken(this.slimBoard.emptyToken());
    }

    @Override
    public IC4Position[] getPositionsByPlayer(IC4Player player) {
        return this.getPositionsByToken(player.getToken());
    }

    private IC4Position[] getPositionsByToken(int token) {
        long[] buffer = this.localPositionBuffer.get();
        int positionsRead = this.slimBoard.getDematPositionsByTokenUnsafe(buffer, token);
        IC4Position[] positions = new IC4Position[positionsRead];
        for (int i = 0; i < positions.length && i < buffer.length; ++i) {
            positions[i] = C4PositionMaterializer.rematerialize(buffer[i]);
        }
        return positions;
    }

    @Override
    public IC4Position[] getLegalPositions() {
        long[] buffer = this.localPositionBuffer.get();
        int positionsRead = this.slimBoard.getLegalDematPositionsUnsafe(buffer);
        IC4Position[] positions = new IC4Position[positionsRead];
        for (int i = 0; i < positions.length && i < buffer.length; ++i) {
            positions[i] = C4PositionMaterializer.rematerialize(buffer[i]);
        }
        return positions;
    }

    @Override
    public int countEmptyPositions() {
        return this.countPositionsByToken(this.slimBoard.emptyToken());
    }

    @Override
    public int countPositionsByPlayer(IC4Player player) {
        return this.countPositionsByToken(player.getToken());
    }

    private int countPositionsByToken(int token) {
        long[] buffer = this.localPositionBuffer.get();
        return this.slimBoard.getDematPositionsByTokenUnsafe(buffer, token);
    }

    @Override
    public int countLegalPositions() {
        long[] buffer = this.localPositionBuffer.get();
        return this.slimBoard.getLegalDematPositionsUnsafe(buffer);
    }

    public int hashCode() {
        int[] board;
        int hash = 7;
        for (int token : board = this.slimBoard.getBoardStateUnsafe()) {
            hash = hash * 31 + token;
        }
        hash = hash * 31 + this.getMinimumSolutionSize();
        hash = hash * 31 + this.getRowCount();
        hash = hash * 31 + this.getColumnCount();
        return hash;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IC4Board)) {
            return false;
        }
        IC4Board other = (IC4Board)object;
        if (this.getRowCount() != other.getRowCount() || this.getColumnCount() != other.getColumnCount()) {
            return false;
        }
        int[] myBoard = this.slimBoard.getBoardStateUnsafe();
        int[] otherBoard = other.getInternalBoard().getBoardStateUnsafe();
        for (int i = 0; i < myBoard.length; ++i) {
            if (myBoard[i] == otherBoard[i]) continue;
            return false;
        }
        return this.getMinimumSolutionSize() == other.getMinimumSolutionSize();
    }

    @Override
    public boolean isFull() {
        return this.slimBoard.isFull();
    }

    public String toString() {
        return "C4Board{slimBoard=" + this.slimBoard + "}";
    }
}

