/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.impl;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgPlayer;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgPlayerBuilder;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.impl.FzgPlayerImpl;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.AnswerOptions;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class FzgPlayerBuilderImpl
implements FzgPlayerBuilder {
    private Optional<String> name = Optional.empty();
    private Optional<Map<AnswerOptions, Map<AnswerOptions, Double>>> possibleOutcomes = Optional.empty();

    @Override
    public FzgPlayerBuilder changeName(String newName) {
        this.name = Optional.of(newName);
        return this;
    }

    @Override
    public FzgPlayerBuilder changePossibleOutcomes(Map<AnswerOptions, Map<AnswerOptions, Double>> newPossibleOutcomes) {
        this.possibleOutcomes = Optional.of(newPossibleOutcomes);
        return this;
    }

    @Override
    public FzgPlayer build() throws GameException {
        return new FzgPlayerImpl(this.name.orElseThrow(), this.checkPossibleOutcomes(this.possibleOutcomes.orElseThrow()));
    }

    private Map<AnswerOptions, Map<AnswerOptions, Double>> checkPossibleOutcomes(Map<AnswerOptions, Map<AnswerOptions, Double>> outcomes) {
        this.checkPossibleOutcome(outcomes, AnswerOptions.CINEMA, AnswerOptions.CINEMA);
        this.checkPossibleOutcome(outcomes, AnswerOptions.CINEMA, AnswerOptions.FOOTBALL);
        this.checkPossibleOutcome(outcomes, AnswerOptions.FOOTBALL, AnswerOptions.CINEMA);
        this.checkPossibleOutcome(outcomes, AnswerOptions.FOOTBALL, AnswerOptions.FOOTBALL);
        return outcomes;
    }

    private void checkPossibleOutcome(Map<AnswerOptions, Map<AnswerOptions, Double>> outcomes, AnswerOptions firstChoice, AnswerOptions secondChoice) {
        if (outcomes.getOrDefault((Object)firstChoice, Collections.emptyMap()).get((Object)secondChoice) == null) {
            throw new IllegalArgumentException(String.format("No outcome defined for player '%s' and combination %s/%s.", new Object[]{this.name.get(), firstChoice, secondChoice}));
        }
    }
}

