/*
 * Decompiled with CFR 0.152.
 */
package de.fhdw.gaming.ipspiel23.freizeitgestaltung.strategy;

import de.fhdw.gaming.core.domain.GameException;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgPlayer;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgState;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.domain.FzgStrategy;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.Answer;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.AnswerOptions;
import de.fhdw.gaming.ipspiel23.freizeitgestaltung.move.factory.AnswerFactory;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

public class MixedStrategy
implements FzgStrategy {
    private static final Random RANDOM = new Random();
    private final AnswerFactory answerFactory;

    public MixedStrategy(AnswerFactory answerFactory) {
        this.answerFactory = answerFactory;
    }

    public Optional<Answer> computeNextMove(int gameId, FzgPlayer player, FzgState state) throws GameException, InterruptedException {
        FzgPlayer otherPlayer = state.getFirstPlayer().equals(player) ? state.getSecondPlayer() : state.getFirstPlayer();
        Map<AnswerOptions, Map<AnswerOptions, Double>> outcomes = otherPlayer.getPossibleOutcomes();
        double a11 = outcomes.get((Object)AnswerOptions.CINEMA).get((Object)AnswerOptions.CINEMA);
        double a12 = outcomes.get((Object)AnswerOptions.CINEMA).get((Object)AnswerOptions.FOOTBALL);
        double a21 = outcomes.get((Object)AnswerOptions.FOOTBALL).get((Object)AnswerOptions.CINEMA);
        double a22 = outcomes.get((Object)AnswerOptions.FOOTBALL).get((Object)AnswerOptions.FOOTBALL);
        double cinemaLikeliness = (a12 + a22) / (a11 - a12 - a21 + a22);
        double percentage = RANDOM.nextDouble();
        if (percentage <= cinemaLikeliness) {
            return Optional.of(this.answerFactory.createCinemaAnswer());
        }
        return Optional.of(this.answerFactory.createFootballAnswer());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

