package de.fhdw.gaming.ipspiel23.c4.moves.factory;

import de.fhdw.gaming.ipspiel23.c4.domain.IC4Position;
import de.fhdw.gaming.ipspiel23.c4.domain.IC4Player;
import de.fhdw.gaming.ipspiel23.c4.moves.IC4Move;

/**
 * A factory for creating {@link IC4Move} instances.
 */
public interface IC4MoveFactory {

    /**
     * Creates a new {@link IC4Move} instance.
     * 
     * @param player The player that makes the move.
     * @param position The position of the move.
     * @return The created {@link IC4Move} instance.
     */
    IC4Move createMove(IC4Player player, IC4Position position);

    /**
     * Creates a new {@link IC4Move} instance.
     * 
     * @param player The player that makes the move.
     * @param row The row of the move.
     * @param column The column of the move.
     * @return The created {@link IC4Move} instance.
     */
    IC4Move createMove(IC4Player player, int row, int column);
}

